%
%  >> y = Auto( 'VW_Golf', 2010 );
%  >> y = y.beschleunigen( 30 );
%  >> y.print
%  >> y
%  >> y.benzin 
%  >> y = y.hauptuntersuchung;
%
classdef Auto
  properties 
    typ = '';
    baujahr = -1;
    kilometer = -1;
    geschwindigkeit = -1;
    benzin = -1;
    hu = -1;
    farbe = '';
  end

  methods
    function obj = Auto( typ, baujahr )
      obj.typ = typ;
      obj.baujahr = baujahr;
      obj.kilometer = 0;          % 0 km
      obj.geschwindigkeit = 100;  % 100 km/h
      obj.benzin = 20;            % 20 Liter im Tank
      obj.hu = baujahr;
      obj.farbe = 'rot';
    end
    
    function obj = beschleunigen( obj, wieviel )
      neueGeschwindigkeit = obj.geschwindigkeit + wieviel;
      obj.geschwindigkeit = neueGeschwindigkeit;
    end
    
    function obj = hauptuntersuchung( obj )
      obj.hu = obj.hu + 2;
      fprintf( 'Neue TV-Plakette fr %s gltig bis %g \n', ... 
               obj.typ, obj.hu );
    end   
    
    function print( obj )
      fprintf( 'Objekt der Klasse Auto: \n' );
      fprintf( '   typ = %s;\n', obj.typ );
      fprintf( '   geschwindigkeit = %g;\n', obj.geschwindigkeit );
    end
	
  end
end
