function CaesarCrypt( txtFile, cryptFile, incr ) 

    if( incr > 26 || incr < -26 )
       fprintf( '\nFEHLER: incr muss zwischen -26 und +26 liegen! \n\n' ); 
       return;
    end

    fid1 = fopen( txtFile, 'r' );
    if( fid1 < 0 )     % Check, ob fid gltig ist
       return;
    end
    
    fid2 = fopen( cryptFile, 'w' );
    if( fid2 < 0 )     % Check, ob fid gltig ist
       fclose( fid1 );
       return;
    end
    
    % so lange weiter, bis Ende der Text-Datei erreicht ist 
    weiter = 1; % Flag als Merker, ob Datei-Ende erreicht ist 
    while( weiter ) 
       % nchste Zeile einlesen 
       tline = fgetl( fid1 ); 
       if( tline == -1 ) % Datei-Ende erreicht, falls tline = -1 
          weiter = 0; % Flag zum Beenden setzen 
       else
          % Zeile verschlsseln: 
          crypt = encryptLine( tline, incr ); 
           
          % verschl. Text mit Zeilenumbruch in die neue Datei schreiben           
          fprintf( fid2, '%s \n', crypt ); 
       end
    end    
    
    fclose( fid1 ); 
    fclose( fid2 );

end

% aktuelle Zeile verschlsseln 
function crypt = encryptLine( tline, incr )
    len = length( tline );
    minUChar = int32( 'A' );
    maxUChar = int32( 'Z' );
    minLChar = int32( 'a' );
    maxLChar = int32( 'z' );
      
    crypt = '';
    
    % alle Zeichen untersuchen
    for( n=1:len )   
        
        % ASCII-Wert den n. Buchstaben holen  
        actNum = int32( tline( n ) );
        
        % Grobuchstaben: 
        if( actNum >= minUChar && actNum <= maxUChar )
            crNum = actNum + incr;
            % ber 'Z' hinaus, dann modulo 26
            if( crNum > maxUChar )
                crNum = crNum - 26;
            % vor 'A', dann 26 dazu      
            elseif( crNum < minUChar )
                crNum = crNum + 26;
            end
        
        % Kleinbuchstaben: 
        elseif( actNum >= minLChar && actNum <= maxLChar )
            crNum = actNum + incr;
            if( crNum > maxLChar )
                crNum = crNum - 26;
            elseif( crNum < minLChar )
                crNum = crNum + 26;
            end
        
        % Restliche Zeichen nicht verndern
        else
           crNum = actNum;   
        end
        
        crypt(n) = char( crNum );
    end

end
