classdef GeBody
    
  properties 
    pts = GePt.empty();
    lns = GeLn.empty();
  end  % properties

  methods
    % Konstruktor
    function obj = GeBody()
      obj.pts = GePt.empty();
      obj.lns = GeLn.empty();
    end
     
    function obj = addPt( obj, x, y, z )
      n = length( obj.pts ) + 1;
      pt = GePt( x,y,z );
      obj.pts(n) = pt;
    end
    
    function obj = addLn( obj, p1 , p2 )
      n = length( obj.lns ) + 1;
      ln = GeLn( p1, p2 );
      obj.lns(n) = ln;
    end

    function drawLines( obj )
       hold on;
       nmax = length( obj.lns );   % % Anzahl der Linien
       % alle Linien nacheinander zeichnen
       for( n = 1:nmax )
          line = obj.lns( n );
          p1 = line.p1;           p2 = line.p2;
          % 1. Punkt der Linie    2. Punkt der Linie
          x(1) = obj.pts(p1).x;   x(2) = obj.pts(p2).x;
          y(1) = obj.pts(p1).y;   y(2) = obj.pts(p2).y;
          z(1) = obj.pts(p1).z;   z(2) = obj.pts(p2).z;
          % 3D-Zeichenroutine fr eine Linie mit 2 Punkten
          plot3( x,y,z, '-sb' );
       end
       view( 36, 20 );
       axis equal;
       hold off;
    end
  end  % methods
    
end  % classdef
