function koerper()
% Aufgabe 2.8.3: zeichnet verschiedene 3D-Krper
%    koerper() 

    pt = struct( 'x', 0, 'y', 0, 'z', 0 );
    ln = struct( 'p1', [], 'p2', [] );
    
    typ = input( 'Krper-Typ (p=Pyramide, q=Quader): ' );
    
    % Unterschiedliche Geometrien je nach Krpertyp:
    anzLn  = 0;
    laenge = 0;
    hoehe  = 0;
    switch( typ )
       case 'p'
          anzLn = 8;
          laenge = input( 'Seitenlnge der Pyramide: ' );
          hoehe  = input( 'Hhe der Pyramide: ' );
          
          % Definition der Punkte des Krpers
          pt(1).x = 0;        pt(1).y = 0;        pt(1).z = 0; 
          pt(2).x = laenge;   pt(2).y = 0;        pt(2).z = 0; 
          pt(3).x = laenge;   pt(3).y = laenge;   pt(3).z = 0; 
          pt(4).x = 0;        pt(4).y = laenge;   pt(4).z = 0; 
          pt(5).x = laenge/2; pt(5).y = laenge/2; pt(5).z = hoehe; 

          % Definition der Linien des Krpers ber Punkte 
          ln(1) = struct( 'p1', pt(1), 'p2', pt(2) );
          ln(2) = struct( 'p1', pt(2), 'p2', pt(3) );
          ln(3) = struct( 'p1', pt(3), 'p2', pt(4) );
          ln(4) = struct( 'p1', pt(4), 'p2', pt(1) );

          ln(5) = struct( 'p1', pt(1), 'p2', pt(5) );
          ln(6) = struct( 'p1', pt(2), 'p2', pt(5) );
          ln(7) = struct( 'p1', pt(3), 'p2', pt(5) );
          ln(8) = struct( 'p1', pt(4), 'p2', pt(5) );
          
       case 'q'
          anzLn = 12;
          laenge = input( 'Seitenlnge des Quaders: ' );
          hoehe  = input( 'Hhe des Quaders: ' );
          
          % Definition der Punkte des Krpers
          pt(1).x = 0;        pt(1).y = 0;        pt(1).z = 0; 
          pt(2).x = laenge;   pt(2).y = 0;        pt(2).z = 0; 
          pt(3).x = laenge;   pt(3).y = laenge;   pt(3).z = 0; 
          pt(4).x = 0;        pt(4).y = laenge;   pt(4).z = 0; 
          pt(5).x = 0;        pt(5).y = 0;        pt(5).z = hoehe; 
          pt(6).x = laenge;   pt(6).y = 0;        pt(6).z = hoehe; 
          pt(7).x = laenge;   pt(7).y = laenge;   pt(7).z = hoehe; 
          pt(8).x = 0;        pt(8).y = laenge;   pt(8).z = hoehe; 

          % Definition der Linien des Krpers ber Punkte 
          ln(1) = struct( 'p1', pt(1), 'p2', pt(2) );
          ln(2) = struct( 'p1', pt(2), 'p2', pt(3) );
          ln(3) = struct( 'p1', pt(3), 'p2', pt(4) );
          ln(4) = struct( 'p1', pt(4), 'p2', pt(1) );

          ln(5) = struct( 'p1', pt(1), 'p2', pt(5) );
          ln(6) = struct( 'p1', pt(2), 'p2', pt(6) );
          ln(7) = struct( 'p1', pt(3), 'p2', pt(7) );
          ln(8) = struct( 'p1', pt(4), 'p2', pt(8) );
          
          ln(9)  = struct( 'p1', pt(5), 'p2', pt(6) );
          ln(10) = struct( 'p1', pt(6), 'p2', pt(7) );
          ln(11) = struct( 'p1', pt(7), 'p2', pt(8) );
          ln(12) = struct( 'p1', pt(8), 'p2', pt(5) );

       otherwise
          fprintf( 'Unbekannter Typ! \n' );
          return; 
    end
          
    % Aufruf der Zeichen-Funktion
    drawLines( ln, anzLn );
    
    % Ansicht und Bildgre bestimmen
    view( 30, 20 );
    axis( [-2, laenge+2, -2, laenge+2, -2, hoehe+2] );
    
return;


function drawLines( line, nmax )

    figure;
    hold on;

    for n = 1:nmax
        x(1) = line(n).p1.x;
        y(1) = line(n).p1.y;
        z(1) = line(n).p1.z;
        
        x(2) = line(n).p2.x;
        y(2) = line(n).p2.y;
        z(2) = line(n).p2.z;
        
        plot3( x,y,z, '-s' );
    end
            
    hold off;
    
return;
