% Aufgabe 2.5.5: berechnet den Sinus
%    y = sinus( x, epsi, ausgabe ) 
%    x : Winkel im Bogenma
%    epsi : Schranke zum Abbruch
%    ausgabe : ob Zahl der Summanden ausgegeben wird
%
%    Verwendete Rekursionsformel fr Summenglieder:
%       sn = - sn * x*x / ( n*(n-1) ) 
%       mit Startwert: s1 = x
function y = sinus( x, epsi, ausgabe ) 
   n = 1;     % 1 = Startnummer des Summanden 
   sn = x;    % 1. Summand = x 
   z = sn;    % Zwischensumme = x
   
   while( abs(sn) > epsi ) % Kriterium zum Weitermachen 
      n = n + 2;        % nchste Summandennummer 
      sn = - sn * x*x / ( n *(n-1) );  % aktueller Summand 
      z = z + sn;       % Summand zu Zwischensumme addieren 
   end

   y = z; % Rckgabe der Summe 
   if( ausgabe ) % Kontrollausgabe, falls ausgabe == 1 
      fprintf( 'Zahl der Summanden: %g \n', n ); 
      fprintf( 'Wert sinus(%g) = %16.15g \n', x, y );
      fprintf( 'Differenz zu MATLAB-sin: %g \n', y - sin(x) );
   end
end
   