% Aufgabe 2.10.2: wandelt einen Text- in einen HTML-File
%    erg = txt2html( txtFile, htmlFile )
function  erg = txt2html( txtFile, htmlFile )
    erg = 0;
    
    fid1 = fopen( txtFile, 'r' );
    if( fid1 < 0 )     % Check, ob fid gltig ist
       return;
    end
    
    fid2 = fopen( htmlFile, 'w' );
    if( fid2 < 0 )     % Check, ob fid gltig ist
       fclose( fid1 );
       return;
    end

    fprintf( fid2, '<HTML> \n' );
    fprintf( fid2, '<HEAD> <TITLE>Von txt zu html</TITLE> </HEAD> \n' );
    fprintf( fid2, '<BODY> \n' );
    
    % so lange weiter, bis Ende der Text-Datei erreicht ist 
    weiter = 1; % Flag als Merker, ob Datei-Ende erreicht ist 
    while( weiter ) 
       % nchste Zeile einlesen 
       tline = fgetl( fid1 ); 
       if( tline == -1 ) % Datei-Ende erreicht, falls tline = -1 
          weiter = 0; % Flag zum Beenden setzen 
       else
          % Zahl der Zeichen in der Zeile
          len = length( tline );
          % alle Zeichen untersuchen
          for( n=1:len )
             z = '';
             % n. Zeichen der Zeile checken
             switch( tline( n ) )
                case ''
                   z = '&auml;';
                case ''
                   z = '&ouml;';
                case ''
                   z = '&uuml;';
                case ''
                   z = '&Auml;';
                case ''
                   z = '&Ouml;';
                case ''
                   z = '&Uuml;';
                case ''
                   z = '&szlig';
                % normales Zeichen
                otherwise
                   z = tline( n );
             end
             % evtl. gewandeltes Zeichen in Datei schreiben
             fprintf( fid2, '%s', z );
          end
          
          % Zeilenende in die neue Datei schreiben           
          fprintf( fid2, '<br> \n' ); 
       end
    end

    fprintf( fid2, '</BODY> \n' );
    fprintf( fid2, '</HTML> \n' );

    fclose( fid1 ); 
    fclose( fid2 ); 
    
    erg = 1;
end