function l06_draw

    global l06_data;  
    
    fz = l06_data.p(1);
    fs = l06_data.p(2);
    
    dist_2 = l06_data.sicht * l06_data.sicht;
    
    for( m=1 : l06_data.zeilen )
      for( n=1 : l06_data.spalten )
          
         abstand_2 = (fz-m)*(fz-m) + (fs-n)*(fs-n);
         
         % beschrnkte Sicht ?
         if( dist_2 > 0  &  abstand_2 > dist_2 )
             % graues Feld
             l06_zeichne_grau( m, n );
         else
             % Stein zeichnen zu Nummer 0
             if( l06_data.feld(m,n) == 0 )   
               l06_zeichne_stein( m, n );
             else
               l06_leeres_feld( m,n );  
             end
         end
      end
    end
    
    % Ziel zeichnen
    l06_zeichne_ziel( l06_data.ziel(1), l06_data.ziel(2) );
    
    % Figur zeichnen
    l06_zeichne_figur( l06_data.p(1), l06_data.p(2) );
   
    % vor dem image zur Sicherheit nach uint8 wandeln
    l06_data.imag = uint8( l06_data.imag );

    % Und das Image anzeigen 
    image( l06_data.imag )
    axis image
    
return;


function l06_zeichne_grau( m, n )

    global l06_data;  
    
    z_w = l06_data.fig(1);
    s_w = l06_data.fig(2);
        
    for( r=1 : z_w )
      for( s =1 : s_w ) 
         l06_data.imag( (m-1)*z_w+r ,(n-1)*s_w+s, 1) = uint8( 130 );
         l06_data.imag( (m-1)*z_w+r ,(n-1)*s_w+s, 2) = uint8( 130 );
         l06_data.imag( (m-1)*z_w+r ,(n-1)*s_w+s, 3) = uint8( 130 );
      end
    end
               
return;