% Spieldaten einlesen
function l06_lese_spiel( FileName, PathName )

    global l06_data;  
    
    l06_data.fig = [16,20];
    l06_data.geladen = 0;
        
    fid = fopen( FileName, 'r' );
    if( fid == -1 )
       beep;
       msg = ['Datei ', FileName, ' konnte nicht geffnet werden!'];
       errordlg( msg );
       return;
    end
    
    tline = fgetl(fid);
    if( l06_check_zeile1( tline ) == 1 ) 
      beep;
      errordlg( [FileName, ' ist keine gltige Labyrinth-Datei!'] );   
      fclose( fid );
      return;
    end
    
    while( 1 )
        tline = fgetl(fid);
        if ~ischar(tline)
            break;
        end
        
        if( l06_next_line(tline) == 1 )
          beep;
          errordlg( [FileName, ' ist keine gltige Labyrinth-Datei!'] );   
          fclose( fid );
          return;
        end  
    end
    
    fclose( fid );
    
    l06_data.geladen = 1;
    l06_data.p_v = l06_data.p;
    l06_data.p_n = l06_data.p;
    
    % Spielfeld zeichnen
    l06_draw;
    
return;

% in 1. Zeile muss 'l06' stehen
function r = l06_check_zeile1( tline )
    % Check 1. Zeile
    if( strcmp( tline, 'l06' ) == 1 )
        r = 0;
    else
        r = 1;
    end

return;

% nchste Zeile einlesen
function r = l06_next_line( tline )

    global l06_data;  
    
    r = 0;
    akt_zeile = 0;
    vor_zeile = 0;
    
    % 1. Zeichen der Zeile lesen
    c1 = tline(1);
    switch( c1 )
        % Kommentarzeile
        case '%'
            return;  
        case ' '
            return;
         
        % Zeilenzahl    
        case 'z'
            ln = sscanf( tline, '%c %lg' );
            l06_data.zeilen  = ln(2);
        
        % Spaltenzahl
        case 's'
            ln = sscanf( tline, '%c %lg' );
            l06_data.spalten  = ln(2);

            % Arrays initialisieren 
            if( l06_data.zeilen > 0 ) 
              l06_data_init;
            end
            
        % Startposition    
        case 'p'
            ln = sscanf( tline, '%c %lg %lg' );
            l06_data.p(1) = ln(2);
            l06_data.p(2) = ln(3);
           
        % Endposition (Ziel)    
        case 'e'
            ln = sscanf( tline, '%c %lg %lg' );
            l06_data.ziel(1) = ln(2);
            l06_data.ziel(2) = ln(3);
           
         % Zeilen mit Steinen 
         case 'n'
            if( l06_data.zeilen == 0 ) 
                beep;
                errordlg( 'Keine Zeilenzahl definiert!');
                r = 1;
                return;
            end
            if( l06_data.spalten == 0 ) 
                beep;
                errordlg( 'Keine Spaltenzahl definiert!');
                r = 1;
                return;
            end
             
            % Zeile einlesen, Steine stehen ab ln(3)
            ln = sscanf( tline, '%c %lg %s' );
            akt_zeile = ln(2);
               
            for( n= 1:l06_data.spalten ) 
              stein = str2double( char(ln(n+2)) );
              l06_data.feld( akt_zeile, n ) = stein;
            end        
          
        otherwise
            errordlg( ['Ungltiger Kenner ',c1] );
            r = 1;
            return;
    end

return


   