% Reaktion auf Cursor-Taste - ziehe Stein
function  l06_ziehe( c ) 

    global l06_data;  
    
    if( l06_data.geladen == 0 )
      beep;
      msgbox( 'Kein Spiel geladen!' );
      return;        
    end

    % aktuelles Feld auslesen
    akt_x = l06_data.p(2);
    akt_y = l06_data.p(1);
    
    next_x = akt_x;
    next_y = akt_y;
    
    % aus Cursor-Taste nchstes Feld bestimmen
    % < : 28, > : 29, ^ : 30, v : 31 
    switch( c )
       case 28  % ein Feld nach links
           next_x = next_x - 1;  
       case 29  % ein Feld nach rechts 
           next_x = next_x + 1;  
       case 30  % ein Feld nach oben 
           next_y = next_y - 1;  
       case 31  % ein Feld nach unten 
           next_y = next_y + 1;  
            
       otherwise
          beep;
          return;    
    end
    
    % Check, ob Nachbarfeld (next_y,next_x) frei ist
    if( l06_data.feld(next_y,next_x) == 0 )
       beep;
       return; 
    end
        
    % neue aktuelle Daten merken
    l06_data.p = [next_y,next_x];
   
    % neu zeichnen
    l06_draw;
    
    
    % Check, ob Ziel erreicht ist
    if( l06_data.ziel(1) == l06_data.p(1) &&  l06_data.ziel(2) == l06_data.p(2) )
        % Spiel ist zu Ende        
        l06_data.geladen = 0;
        
        % Anfrage, ob neues Spiel
        button = questdlg( 'Bravo!  Neues Spiel ?', 'Neues Spiel','Ja','Nein','Ja');
        if( strcmp( button, 'Ja' ) == 1 )
          l06_lade_spiel;  
        end
    end
    
return;