function b = subsref( r, index )
%SUBSREF Define field name indexing for rechteck objects

%   s = index(1).subs;
%   t = index(1).type; 
%   
%   len = length( index );
%   if( len == 2 )
%     s2 = index(2).subs;
%     t2 = index(2).type; 
%   end

  switch index(1).subs
    case 'len'
        b = r.len;
    case 'wid'
        b = r.wid;
    case 'flaeche'
        b = flaeche(r);
    case 'umfang'
        b = umfang(r);
    case 'set' 
        s2 = index(2).subs;
        prop = cell2mat( s2(1) );
        val  = cell2mat( s2(2) );
        b = set( r, prop, val );
    case 'get'
        s2 = index(2).subs; 
        prop = cell2mat( s2(1) ); 
        b = get( r, prop );
    case 'draw'
        b = draw( r );      
    otherwise
        error('Invalid field name')
        b = [];
  end


