function pyramide( laenge, hoehe )
% Parameter: laenge = Kantenlnge, hoehe = Hhe der Pyramide 
   % pt = struct der 5 Eckpunkte mit den Koordinaten x,y,z
   pt(1).x = 0;        pt(1).y = 0;        pt(1).z = 0; 
   pt(2).x = laenge;   pt(2).y = 0;        pt(2).z = 0; 
   pt(3).x = laenge;   pt(3).y = laenge;   pt(3).z = 0; 
   pt(4).x = 0;        pt(4).y = laenge;   pt(4).z = 0; 
   pt(5).x = laenge/2; pt(5).y = laenge/2; pt(5).z = hoehe; 

   % ln = struct der 8 Krper-Linien mit den Eckpunktnummern p1, p2 
   ln(1) = struct('p1',1,'p2',2);  ln(2) = struct('p1',2,'p2',3);
   ln(3) = struct('p1',3,'p2',4);  ln(4) = struct('p1',4,'p2',1);
   ln(5) = struct('p1',1,'p2',5);  ln(6) = struct('p1',2,'p2',5);
   ln(7) = struct('p1',3,'p2',5);  ln(8) = struct('p1',4,'p2',5);

   % Aufruf der Zeichen-Funktion: 
   drawLines( ln, pt );

   % Ansicht und Bildgre bestimmen
   view( 30, 20 );   axis([-2, 12, -2, 12, -2, 14]);  
   return;

% Unterfunktion drawLines
function drawLines( line, pt )
   hold on;
   nmax = length( line );   % % Anzahl der Linien

   % alle Linien nacheinander zeichnen
   for( n = 1:nmax )
      % 1. Punkt der Linie         2. Punkt der Linie
      x(1) = pt( line(n).p1 ).x;   x(2) = pt( line(n).p2 ).x;
      y(1) = pt( line(n).p1 ).y;   y(2) = pt( line(n).p2 ).y;
      z(1) = pt( line(n).p1 ).z;   z(2) = pt( line(n).p2 ).z;

      % 3D-Zeichenroutine fr eine Linie mit 2 Punkten
      plot3( x,y,z, '-s' );
   end

   hold off;
   return;
