classdef app1 < matlab.apps.AppBase

  % Properties that correspond to app components
  properties (Access = public)
    UIFigure  matlab.ui.Figure
    OKButton  matlab.ui.control.Button
  end

  % Callbacks that handle component events
  methods (Access = private)

    % Button pushed function: OKButton
    function OKButtonPushed(app, event)
      f = figure;
      a = axes(f);
      plot( a, [2,5], [1,3] ); 
      axis( [0,8,0,5] );
    end
  end

  % Component initialization
  methods (Access = private)

    % Create UIFigure and components
    function createComponents(app)

      % Create UIFigure and hide until all components are created
      app.UIFigure = uifigure('Visible', 'off');
      app.UIFigure.Position = [100 100 640 480];
      app.UIFigure.Name = 'MATLAB App';

      % Create OKButton
      app.OKButton = uibutton(app.UIFigure, 'push');
      app.OKButton.ButtonPushedFcn = createCallbackFcn(app, @OKButtonPushed, true);
      app.OKButton.Position = [271 329 100 23];
      app.OKButton.Text = 'OK';

      % Show the figure after all components are created
      app.UIFigure.Visible = 'on';
    end
  end

  % App creation and deletion
  methods (Access = public)

    % Construct app
    function app = app1

      % Create UIFigure and components
      createComponents(app)

      % Register the app with App Designer
      registerApp(app, app.UIFigure)

      if nargout == 0
        clear app
      end
    end

    % Code that executes before app deletion
    function delete(app)

      % Delete UIFigure when app is deleted
      delete(app.UIFigure)
    end
  end
end