%
%   [t,z] = EulerVerfahren( @D1, [0,5], 0, 1, [] )
%
function [t,z] = EulerVerfahren( DglFun, tspan, z0, h, par )
  t0 = tspan(1); % Startpunkt des Zeitintervalls
  te = tspan(2); % Endpunkt des Zeitintervalls
  t = t0:h:te; % Intervall von t0 bis te, Schrittweite h
  anz = length(t); % Anzahl der Sttzstellen
  z(1) = z0; % Anfangswert
  for( n=1:anz-1 ) % Iteration: Polygonzug-Verfahren
    % Auswertung der bergebenen Funktion DglFun
    z(n+1) = z(n) + h*DglFun( t(n), z(n), par );
  end
end