function anz = ExcelDGL1()

   x0 = [10];       % Anfangswert
   tspan = [0,4];   % Zeit-Intervall
   [t,x] = ode45( 'DglGl', tspan, x0 );
   
   anz = length( x );

   h = actxserver( 'Excel.Application' );
   hWBs = h.Workbooks; 
   map = hWBs.Add;	
   Tabellen = map.Sheets; 
   Tab1 = Tabellen.get( 'Item', 1 ); 
   
   AStr = sprintf( 'A1:A%d', anz ); 
   AZelle = Tab1.get( 'Range', AStr ); 
   AZelle.Value = t;  
   BStr = sprintf( 'B1:B%d', anz );
   BZelle = Tab1.get( 'Range', BStr );
   BZelle.Value = x;    
       
   map.SaveAs( 'DGL1.xls' ); 
   map.Close   % Excel-Datei schlieen
   h.Quit      % COM-Server fr Excel beenden
   h.delete    % COM-Objekt entfernen 