%
%   >> [x0,v0,g] = FallParameter([0 0.5 1 1.5 2],[2 1.5 -2 -7.5 -15.5])
%
function [x0,v0,g] = FallParameter( t, x )
  p = polyfit( t, x, 2 );
  x0 = p(3);
  v0 = p(2);
  g  = -2*p(1);
  if( g < 9 || g > 11 )   % Check der Erdbeschleunigung g
    txt = sprintf( 'g = %g, ungenau!', g );
    warndlg( txt )
  end
  % zum Plotten 10 Zwischenpunkte auf der Parabel bestimmen
  len = length( t );
  tt = linspace( t(1), t(len), 10 );
  xx = polyval( p, tt );    % Punkte auf Parabel
  plot( t, x, 'sk', tt, xx, '-b' )
end