classdef Labyrinth 

  properties
    axes 
    geladen = 0;
    zeilen  = 0; 
    spalten = 0; 
    p = []; 
    ziel = []; 
    feld = []; 
    imag = []; 
    fig = [16,20]; % Größe der Figuren
  end

  methods
    function obj = Labyrinth(axes)
      obj.geladen = 0;
      obj = data_clear( obj );
      obj.axes = axes;
    end

    function obj = data_init(obj)
      for( m=1 : obj.zeilen )
        for( n=1 : obj.spalten )
           % Feld mit 0 vorbelegen 
           obj.feld(m,n) = 0;
           % leeres Feld in imag eintragen
           obj = leeres_feld( obj, m, n );    
        end
      end
    end

    function obj = data_clear( obj )
      % Datenbasis initialisieren
      obj.geladen = 0;
      obj.zeilen = 0; 
      obj.spalten = 0; 
      obj.p = []; 
      obj.ziel = []; 
      obj.feld = []; 
      obj.imag = []; 
      obj.fig = [16,20]; % Größe der Figuren
    end
    
    % Spieldaten aus Datei laden
    function obj = lade_spiel( obj ) 
      % Abfrage, ob ein Spiel bereits geladen ist
      if( obj.geladen == 1 )
        button = questdlg( 'Aktuelles Spiel beenden ?', ...
                           'Neues Spiel','Ja','Nein','Ja');
        if( strcmp( button, 'Nein' ) == 1 )
          return;
        end 
      end
      
      cla(obj.axes);  % Spielfeld loeschen
      
      % Datenfeld löschen
      obj = data_clear( obj );
  
      % Namen der Spieledatei holen
      [FileName,PathName] = uigetfile( '*.l06', 'Labyrinth wählen' );
      if isequal( FileName, 0 )
        msgbox( 'Kein Labyrinth ausgewählt' );
        return;
      end
      
      % Spieldaten aus Datei einlesen
      obj = lese_spiel( obj, FileName, PathName );
    end    % von lade_spiel
      
    % Spieldaten einlesen
    function obj = lese_spiel( obj, FileName, PathName ) 
      % Versuch, die Datei zu FileName zu öffnen
      file = [PathName,FileName];
      fid = fopen( file, 'r' );
      if( fid == -1 )
         beep;
         errordlg( ['Datei ', file, ' kann nicht geöffnet werden!'] );
         return;
      end
      % Erste Zeile der Datei einlesen und checken
      tline = fgetl(fid); 
      if( check_zeile1( obj, tline ) == 1 ) 
        beep;
        errordlg( [FileName, ' ist keine gültige Labyrinth-Datei!'] );   
        fclose( fid );
        return;
      end
      
      % alle Zeilen der Datei nacheinander lesen (Totschleife)
      while( 1 )
        tline = fgetl(fid);   % Zeile einlesen 
        % Check, ob Datei-Ende erreicht ist
        if ~ischar(tline)
          break;
        end
          
        % Analyse der gerade eingelesenen Zeile
        [obj,r] = next_line(obj,tline);
        if( r == 1 )
          beep;
          errordlg( [FileName, ' ist keine gültige Labyrinth-Datei!'] );   
          fclose( fid );
          return;
        end  
      end
      
      fclose( fid );
      
      % Flag, dass jetzt die Daten vorhanden sind
      obj.geladen = 1;
      
      % Spielfeld zeichnen
      obj = draw_field(obj);
    end
    %--- Ende der Funktion lese_spiel ---
  

    % Unterfunktion: check_zeile1
    function r = check_zeile1( obj, tline )
      % Check 1. Zeile
      % in 1. Zeile muss der Kenner 'l06' stehen
      if( strcmp( tline, 'l06' ) == 1 )
        r = 0;
      else
        r = 1;  % falscher Kenner, Rückgabewert 1
      end
    end  

    % next_line zur Analyse der eingelesenen Zeile tline
    function [obj,r] = next_line( obj, tline )
      r = 0;   % Rückgabewert vorbelegen
          
      % 1. Zeichen der Zeile in cl speichern
      c1 = tline(1);
      % Auswahl nach Art des 1. Zeichens der Zeile
      switch( c1 )
        % Kommentar- und Leerzeilen überspringen
        case '%'
          return;  
        case ' '
          return;
         
        % Zeilenzahl bestimmen: Kenner 'z'   
        case 'z'
          % Daten der Zeile in Vektor ln schreiben
          ln = sscanf( tline, '%c %lg' );
          % 2. Eintrag ln(2) enthält die Zeilenzahl
          obj.zeilen  = ln(2);
        
        % Spaltenzahl bestimmen, analog für Kenner 's'
        case 's'
          ln = sscanf( tline, '%c %lg' );
          obj.spalten  = ln(2);
  
          % jetzt die Datenfeld-Arrays initialisieren
          if( obj.zeilen > 0 ) 
            obj = data_init(obj);
          end
            
        % Startposition bestimmen: Kenner 'p'  
        case 'p'
          ln = sscanf( tline, '%c %lg %lg' );
          % 2. Eintrag ln(2) enthält die Startzeile
          obj.p(1) = ln(2);
          % 3. Eintrag ln(3) enthält die Startspalte
          obj.p(2) = ln(3);
           
        % Endposition (Ziel) bestimmen, analog für Kenner 'e'  
        case 'e'
          ln = sscanf( tline, '%c %lg %lg' );
          obj.ziel(1) = ln(2);
          obj.ziel(2) = ln(3);
           
        % Labyrinth-Zeile mit den Steinen einlesen 
        case 'n'
          % Checks auf Konsistenz 
          if( obj.zeilen == 0 ) 
            beep;
            errordlg( 'Keine Zeilenzahl definiert!');
            r = 1;  % Fehler, deshalb r = 1 und raus
            return;
          end
          if( obj.spalten == 0 ) 
            beep;
            errordlg( 'Keine Spaltenzahl definiert!');
            r = 1;  % Fehler, deshalb r = 1 und raus
            return;
          end
             
          % Zeile einlesen, Steine stehen ab ln(3)
          ln = sscanf( tline, '%c %lg %s' );
          % 2. Eintrag enthält Nummer der Spielzeile
          akt_zeile = ln(2);
               
          % nacheinander den String mit den Steinen analysieren
          for( n= 1:obj.spalten ) 
            % Feldtyp stein: 1=frei, 0=Stein gesetzt
            stein = str2double( char(ln(n+2)) );
            % in Spalte n eintragen, ob Stein gesetzt ist
            obj.feld( akt_zeile, n ) = stein;
          end        
          
        otherwise
          errordlg( ['Ungültiger Kenner ',c1] );
          r = 1;  % Fehler, deshalb r = 1 und raus
          return;
      end
    end   % von next_line


    % Funktion zum Zeichnen des Spielfelds
    function obj = draw_field(obj)
      cla(obj.axes); 
      % in Doppelschleife alle Felder zeichnen
      for( m=1 : obj.zeilen )
        for( n=1 : obj.spalten )
           % 0: Stein zeichnen 
           if( obj.feld(m,n) == 0 )
             obj = zeichne_stein( obj, m, n ); 
           % 1: freies Feld zeichnen 
           else
             obj = leeres_feld( obj, m, n ); 
           end
        end
      end
      
      % Ziel zeichnen
      obj = zeichne_ziel( obj, obj.ziel(1), obj.ziel(2) );    
      % Figur zeichnen
      obj = zeichne_figur( obj, obj.p(1), obj.p(2) );
     
      % vor dem image zur Sicherheit nach uint8 wandeln
      obj.imag = uint8( obj.imag );
      image( obj.axes, obj.imag )  % und das Image anzeigen
      % axis image
    end  % von draw_field 


    % Feld an der Position (m,n) mit weiß belegen 
    function obj = leeres_feld( obj, m, n )
      % Zahl der Pixel des Felds holen
      z_w = obj.fig(1);
      s_w = obj.fig(2);
      for( r=1 : z_w )    % alle Pixel von (m,n) mit weiß belegen 
        for( s =1 : s_w ) 
           obj.imag( (m-1)*z_w+r, (n-1)*s_w+s, 1) = uint8( 255 );
           obj.imag( (m-1)*z_w+r, (n-1)*s_w+s, 2) = uint8( 255 );
           obj.imag( (m-1)*z_w+r, (n-1)*s_w+s, 3) = uint8( 255 );
        end
      end
    end  % von leeres_feld

    % Stein zeichnen, an der Position (m,n)  
    function obj = zeichne_stein( obj, m, n )
      z_w = obj.fig(1);  % Zeilenzahl  = 16
      s_w = obj.fig(2);  % Spaltenzahl = 20  
          
      obj = leeres_feld( obj,m,n );
          
      % Ränder oben und unten
      for( s = 2 : s_w-1 )  % ab 2. bis vorletzter Spalte 
         obj.imag( (m-1)*z_w +2 ,(n-1)*s_w +s, 1) = uint8( 0 );
         obj.imag( (m-1)*z_w +2 ,(n-1)*s_w +s, 2) = uint8( 0 );
         obj.imag( (m-1)*z_w +2 ,(n-1)*s_w +s, 3) = uint8( 0 );
         
         obj.imag( (m-1)*z_w +z_w-1,(n-1)*s_w +s, 1) = uint8( 0 );
         obj.imag( (m-1)*z_w +z_w-1,(n-1)*s_w +s, 2) = uint8( 0 );
         obj.imag( (m-1)*z_w +z_w-1,(n-1)*s_w +s, 3) = uint8( 0 );    
      end
      
      % Ränder links und recht
      for( r = 2 : z_w-1 )  % ab 2. bis vorletzter Zeile
         obj.imag( (m-1)*z_w +r , (n-1)*s_w +2, 1) = uint8( 0 );
         obj.imag( (m-1)*z_w +r , (n-1)*s_w +2, 2) = uint8( 0 );
         obj.imag( (m-1)*z_w +r , (n-1)*s_w +2, 3) = uint8( 0 );
         
         obj.imag( (m-1)*z_w +r , (n-1)*s_w +s_w-1, 1) = uint8( 0 );
         obj.imag( (m-1)*z_w +r , (n-1)*s_w +s_w-1, 2) = uint8( 0 );
         obj.imag( (m-1)*z_w +r , (n-1)*s_w +s_w-1, 3) = uint8( 0 );
      end
      
      % Querstrich in der Mitte 
      mid_y = z_w/2;
      mid_x = s_w/2;
      for( t = -2:2 )
         obj.imag( (m-1)*z_w +mid_y+t , (n-1)*s_w +mid_x+t, 1) = uint8( 0 );
         obj.imag( (m-1)*z_w +mid_y+t , (n-1)*s_w +mid_x+t, 2) = uint8( 0 );
         obj.imag( (m-1)*z_w +mid_y+t , (n-1)*s_w +mid_x+t, 3) = uint8( 0 );
      end
    end  % von zeichne_stein

    % Ziel zeichnen
    function obj = zeichne_ziel( obj, m, n )
      % obj.fig = [16,20];  fest vorgegeben 
      z_w = obj.fig(1);  % Zeilenzahl  = 16
      s_w = obj.fig(2);  % Spaltenzahl = 20  
            
      % Definition der Farben
      fr = 240;  fg = 190;  fb = 30;   % goldener Pokal 
      bw = 255;  bk = 0;    % weiß und schwarz 

      % RGB jeweils als [16,20]-Feld 
      zr = [ bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw; ... 
             bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw; ... 
             bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw; ... 
             bw bw bw bw bw bw bw fr fg fg fg fg fr bw bw bw bw bw bw bw; ... 
             bw bw bw bw bw bw bw fr fr fr fr fr fr bw bw bw bw bw bw bw; ... 
             bw bw bw bw bw bw bw fr fr fr fr fr fr bw bw bw bw bw bw bw; ... 
             bw bw bw bw bw bw bw fr fr fr fr fr fr bw bw bw bw bw bw bw; ... 
             bw bw bw bw bw bw bw fr fr fr fr fr fr bw bw bw bw bw bw bw; ... 
             bw bw bw bw bw bw bw bw fr fr fr fr bw bw bw bw bw bw bw bw; ... 
             bw bw bw bw bw bw bw bw bw fr fr bw bw bw bw bw bw bw bw bw; ... 
             bw bw bw bw bw bw bw bw bw fr fr bw bw bw bw bw bw bw bw bw; ... 
             bw bw bw bw bw bw bw bw bw fr fr bw bw bw bw bw bw bw bw bw; ... 
             bw bw bw bw bw bw bw bw fr fr fr fr bw bw bw bw bw bw bw bw; ... 
             bw bw bw bw bw bw bw fr fr fr fr fr fr bw bw bw bw bw bw bw; ... 
             bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw; ... 
             bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw ];
         
      zg = [ bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw; ... 
             bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw; ... 
             bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw; ... 
             bw bw bw bw bw bw bw fg bk bk bk bk fg bw bw bw bw bw bw bw; ... 
             bw bw bw bw bw bw bw fg fg fg fg fg fg bw bw bw bw bw bw bw; ... 
             bw bw bw bw bw bw bw fg fg fg fg fg fg bw bw bw bw bw bw bw; ... 
             bw bw bw bw bw bw bw fg fg fg fg fg fg bw bw bw bw bw bw bw; ... 
             bw bw bw bw bw bw bw fg fg fg fg fg fg bw bw bw bw bw bw bw; ... 
             bw bw bw bw bw bw bw bw fg fg fg fg bw bw bw bw bw bw bw bw; ... 
             bw bw bw bw bw bw bw bw bw fg fg bw bw bw bw bw bw bw bw bw; ... 
             bw bw bw bw bw bw bw bw bw fg fg bw bw bw bw bw bw bw bw bw; ... 
             bw bw bw bw bw bw bw bw bw fg fg bw bw bw bw bw bw bw bw bw; ... 
             bw bw bw bw bw bw bw bw fg fg fg fg bw bw bw bw bw bw bw bw; ... 
             bw bw bw bw bw bw bw fg fg fg fg fg fg bw bw bw bw bw bw bw; ... 
             bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw; ... 
             bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw ];
         
      zb = [ bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw; ... 
             bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw; ... 
             bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw; ... 
             bw bw bw bw bw bw bw fb bk bk bk bk fb bw bw bw bw bw bw bw; ... 
             bw bw bw bw bw bw bw fb fb fb fb fb fb bw bw bw bw bw bw bw; ... 
             bw bw bw bw bw bw bw fb fb fb fb fb fb bw bw bw bw bw bw bw; ... 
             bw bw bw bw bw bw bw fb fb fb fb fb fb bw bw bw bw bw bw bw; ... 
             bw bw bw bw bw bw bw fb fb fb fb fb fb bw bw bw bw bw bw bw; ... 
             bw bw bw bw bw bw bw bw fb fb fb fb bw bw bw bw bw bw bw bw; ... 
             bw bw bw bw bw bw bw bw bw fb fb bw bw bw bw bw bw bw bw bw; ... 
             bw bw bw bw bw bw bw bw bw fb fb bw bw bw bw bw bw bw bw bw; ... 
             bw bw bw bw bw bw bw bw bw fb fb bw bw bw bw bw bw bw bw bw; ... 
             bw bw bw bw bw bw bw bw fb fb fb fb bw bw bw bw bw bw bw bw; ... 
             bw bw bw bw bw bw bw fb fb fb fb fb fb bw bw bw bw bw bw bw; ... 
             bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw; ... 
             bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw ];
             
      % Farben an obj.imag übertragen 
      for( r =1 : z_w )
        for( s =1 : s_w ) 
           obj.imag( (m-1)*z_w+ r ,(n-1)*s_w+ s, 1) = zr( r,s );
           obj.imag( (m-1)*z_w+ r ,(n-1)*s_w+ s, 2) = zg( r,s );
           obj.imag( (m-1)*z_w+ r ,(n-1)*s_w+ s, 3) = zb( r,s );
        end
      end    
    end  % von zeichne_ziel

    % Figur zeichnen
    function obj = zeichne_figur( obj, m, n )
      % obj.fig = [16,20];  fest vorgegeben 
      z_w = obj.fig(1);  % Zeilenzahl  = 16
      s_w = obj.fig(2);  % Spaltenzahl = 20  
            
      % Definition der Farben
      kr = 200;  kg = 100;  kb = 0;     % Körper
      fr = 0;    fg = 0;    fb = 255;   % Kleidung 
      bw = 255;                         % weißer Hintergrund 
      
      % RGB jeweils als [16,20]-Feld
      zr = [ bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw; ... 
             bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw; ... 
             bw bw bw bw bw bw bw bw fr fr fr fr bw bw bw bw bw bw bw bw; ... 
             bw bw bw bw bw bw bw bw kr kr kr bw bw bw bw bw bw bw bw bw; ... 
             bw bw bw bw bw bw bw bw kr kr kr bw bw bw bw bw bw bw bw bw; ... 
             bw bw bw bw bw bw bw bw bw kr bw bw bw bw bw bw bw bw bw bw; ... 
             bw bw bw bw bw bw bw fr fr fr fr fr bw bw bw bw bw bw bw bw; ... 
             bw bw bw bw bw bw fr bw fr fr fr bw fr bw bw bw bw bw bw bw; ... 
             bw bw bw bw bw bw bw bw fr fr fr bw bw bw bw bw bw bw bw bw; ... 
             bw bw bw bw bw bw bw bw fr fr fr bw bw bw bw bw bw bw bw bw; ... 
             bw bw bw bw bw bw bw bw fr fr fr bw bw bw bw bw bw bw bw bw; ... 
             bw bw bw bw bw bw bw fr bw bw bw fr bw bw bw bw bw bw bw bw; ... 
             bw bw bw bw bw bw bw fr bw bw bw fr bw bw bw bw bw bw bw bw; ... 
             bw bw bw bw bw bw fr fr bw bw bw fr fr bw bw bw bw bw bw bw; ... 
             bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw; ... 
             bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw ];
         
      zg = [ bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw; ... 
             bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw; ... 
             bw bw bw bw bw bw bw bw fg fg fg fg bw bw bw bw bw bw bw bw; ... 
             bw bw bw bw bw bw bw bw kg kg kg bw bw bw bw bw bw bw bw bw; ... 
             bw bw bw bw bw bw bw bw kg kg kg bw bw bw bw bw bw bw bw bw; ... 
             bw bw bw bw bw bw bw bw bw kg bw bw bw bw bw bw bw bw bw bw; ... 
             bw bw bw bw bw bw bw fg fg fg fg fg bw bw bw bw bw bw bw bw; ... 
             bw bw bw bw bw bw fg bw fg fg fg bw fg bw bw bw bw bw bw bw; ... 
             bw bw bw bw bw bw bw bw fg fg fg bw bw bw bw bw bw bw bw bw; ... 
             bw bw bw bw bw bw bw bw fg fg fg bw bw bw bw bw bw bw bw bw; ... 
             bw bw bw bw bw bw bw bw fg fg fg bw bw bw bw bw bw bw bw bw; ... 
             bw bw bw bw bw bw bw fg bw bw bw fg bw bw bw bw bw bw bw bw; ... 
             bw bw bw bw bw bw bw fg bw bw bw fg bw bw bw bw bw bw bw bw; ... 
             bw bw bw bw bw bw fg fg bw bw bw fg fg bw bw bw bw bw bw bw; ... 
             bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw; ... 
             bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw ];
         
      zb = [ bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw; ... 
             bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw; ... 
             bw bw bw bw bw bw bw bw fb fb fb fb bw bw bw bw bw bw bw bw; ... 
             bw bw bw bw bw bw bw bw kb kb kb bw bw bw bw bw bw bw bw bw; ... 
             bw bw bw bw bw bw bw bw kb kb kb bw bw bw bw bw bw bw bw bw; ... 
             bw bw bw bw bw bw bw bw bw kb bw bw bw bw bw bw bw bw bw bw; ... 
             bw bw bw bw bw bw bw fb fb fb fb fb bw bw bw bw bw bw bw bw; ... 
             bw bw bw bw bw bw fb bw fb fb fb bw fb bw bw bw bw bw bw bw; ... 
             bw bw bw bw bw bw bw bw fb fb fb bw bw bw bw bw bw bw bw bw; ... 
             bw bw bw bw bw bw bw bw fb fb fb bw bw bw bw bw bw bw bw bw; ... 
             bw bw bw bw bw bw bw bw fb fb fb bw bw bw bw bw bw bw bw bw; ... 
             bw bw bw bw bw bw bw fb bw bw bw fb bw bw bw bw bw bw bw bw; ... 
             bw bw bw bw bw bw bw fb bw bw bw fb bw bw bw bw bw bw bw bw; ... 
             bw bw bw bw bw bw fb fb bw bw bw fb fb bw bw bw bw bw bw bw; ... 
             bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw; ... 
             bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw ];
        
      % Farben an obj.imag übertragen 
      for( r =1 : z_w )
        for( s =1 : s_w ) 
          obj.imag( (m-1)*z_w+ r ,(n-1)*s_w+ s, 1) = zr( r,s );
          obj.imag( (m-1)*z_w+ r ,(n-1)*s_w+ s, 2) = zg( r,s );
          obj.imag( (m-1)*z_w+ r ,(n-1)*s_w+ s, 3) = zb( r,s );
        end
      end   
    end  % von zeichne_figur 


     % Reaktion auf Cursor-Taste - ziehe Stein
    function  obj = ziehe( obj, c )
    % Konsistenz-Check
      if( obj.geladen == 0 )
        beep;
        msgbox( 'Kein Spiel geladen!' );
        return;        
      end
  
      akt_x = obj.p(2);  % aktuelles Feld auslesen
      akt_y = obj.p(1);
      next_x = akt_x;  % nächstes Feld mit akt. Feld vorbelegen
      next_y = akt_y;
      
      % aus Cursor-Taste nächstes Feld bestimmen
      % < : 'rightarrow', > : 'leftarrow', ^ : 'uparrow', v : 'downarrow' 
      % 
      if( strcmp( c, 'leftarrow' ) == 1 )
        % ein Feld nach links
        next_x = next_x - 1; 
      elseif( strcmp( c, 'rightarrow' ) == 1 ) 
        % ein Feld nach rechts 
        next_x = next_x + 1;  
      elseif( strcmp( c, 'uparrow' ) == 1 ) 
        % ein Feld nach oben 
        next_y = next_y - 1;  
      elseif( strcmp( c, 'downarrow' ) == 1 ) 
        % ein Feld nach unten 
        next_y = next_y + 1;  
      else   % nicht erlaubte Taste
        return;    
      end
      
      % Check, ob Nachbarfeld (next_y,next_x) frei ist
      if( obj.feld(next_y,next_x) == 0 )
        beep;   % Feld ist mit Stein versperrt
        return; 
      end
          
      % neue Figurdaten merken, damit wird dann gezeichnet
      obj.p = [next_y,next_x];
      obj = draw_field(obj);  % neu zeichnen
      
      % Check, ob Ziel erreicht ist: Figur ist auf Ziel
      if( obj.ziel(1) == obj.p(1) &&  ... 
        obj.ziel(2) == obj.p(2) )
        % Spiel ist zu Ende        
        obj.geladen = 0;
        % Anfrage, ob neues Spiel
        button = questdlg( 'Bravo!  Neues Spiel ?', ... 
                           'Neues Spiel','Ja','Nein','Ja');
        if( strcmp( button, 'Ja' ) == 1 )
          obj = lade_spiel( obj );  
        end
      end
    end  % von ziehe

  end  % von methods

end