% 
%   >> SignalArray( [1,0,0.5,0.8,0.2], 440 );
% 
function SignalArray( A, f )
  SR = 40000;            % feste Samplerate
  t = 0 : 1/SR : 2;      % Zeitpunkte von 0 bis 2 s
  anz = length( A );     % Anzahl der Tne in A
  y = 0;                 % Summe der Tne, zu Beginn leer
  for( n=1:anz )         % Addition der anz Tne 
    % zum n. Ton gehrt die Frequenz n*f
    y = y + A(n)*sin(2*pi*n*f*t);
  end

  plot( t, y )          % die ersten 10 Schwingungen zeichnen
  axis( [0,10/f, -3,3] )
end