function  Solve_Feder_1( k, m, s, tm )
   w2 = k / m;     % Quadrat der Kreisfrequenz
   y0 = [ s, 0 ];   % Anfangswerte
   tspan = [0,tm];  % Zeitintervall

   % Lsung des Anfangswertproblems
   [t,y] = ode45( @Fun_Feder_1, tspan, y0, [], w2 );
   z = y(:,1);      % daraus den Funktionswert = 1. Komponente

   % Testausgabe der Frequenz und Vergleich mit bekannter Lsung
   frequenz = sqrt( w2 ) / (2*pi)
   x = s * cos( 2 * pi * frequenz * t );
   % alles plotten
   plot( t, z, t, x, 'r:' );  grid on; 
end