function Vektorfeld()
  [x,y] = meshgrid(2,1:4);  % Punkte: x=2, y=1:4
  % Vektorfeld (DX,DY) in x-Richtung
  DX(1:4,1) = [1,2,3,4];    % x-Beitrag nach oben ansteigend
  DY(1:4,1) = 0;            % y-Beitrag ist immer Null

  % Pfeile (DX,DY) am Punkt (x,y)
  quiver(x,y,DX,DY,5)

  % weitere Verschnerungen
  hold on
  plot( [0,15], [0,0], 'k-', [0,15], [5,5], 'k-' )
  plot( [2,2], [0,5], 'r-', [2,11.4], [0,5], 'r:' )
  axis( [0,15,-1,6] )
  title( 'Vektorfeld fr bewegte gegen ruhende Platte' )
  hold off
end