#include "mex.h"

/* Berechnungsteil: */
static void Addition( double * yp, const double * ap, const double * bp )
{    
   double a, b, c;
   /* Daten aus den Zeigern holen: */
   a = *ap;
   b = *bp;
   
   /* Addition: */
   c = a + b;
   /* Rckgabewert setzen: */
   *yp = c;
   return;
}

/* bergabeteil: */
void mexFunction( int nlhs, mxArray * plhs[], 
                  int nrhs, const mxArray * prhs[] )
{ 
   double * yp, * ap, * bp; 

   /* Check, ob exakt 2 bergabewerte und 1 Rckgabewert */
   if( nrhs != 2 ) 
   { mexErrMsgTxt("FEHLER: Zwei Eingabewerte !"); }  
   if( nlhs > 1 ) 
   { mexErrMsgTxt("FEHLER: Zu viele Rckgabewerte."); } 

   /* Matrix fr die Rckgabewerte erzeugen */ 
   plhs[0] = mxCreateDoubleMatrix( 1, 1, mxREAL ); 
   /* Zeiger auf die verschiedenen Parameterdaten: */ 
   yp = mxGetPr( plhs[0] );
   ap = mxGetPr( prhs[0] ); 
   bp = mxGetPr( prhs[1] );

   /* Addition in der Unterfunktion durchfhren: */
   Addition( yp, ap, bp ); 
   return;
}
