function grauFilter( B ) 
  % in double wandeln, da bei Addition Werte > 255 mglich 
  D = double( B );

  % Fr alle Pixel zu den RGB-Farben den Grauwert berechnen, 
  %   d.h. Addition der 3 Farbwerte (1,2,3), 
  %   dann Division durch 3, 
  %   zum Schluss Rckwandlung in uint8:
  GrauWert(:,:) = uint8( ( D(:,:,1) + D(:,:,2) + D(:,:,3) ) / 3.0 );


  % Fr alle Pixel den Grauwert allen 3 Farbkanlen (1,2,3) zuweisen
  for( f=1:3 ) 
    Grau( :,:,f ) = GrauWert(:,:); 
  end

  % Ausgabe des Bildes mit und ohne Grau-Filter
  subplot( 1,2,1);
  image( B )
  axis image
  subplot( 1,2,2);
  image( Grau )
  axis image
end
