function hochpass( A, min_f )
   % Ursprungsdatei plotten
   figure;  
   subplot(1,2,1);  
   image( A );  
   axis image

   F = fft2( double(A) ); % zweidim. Fourier-Transformation

   % Zeilen- und Spaltenzahl der Fourier-Transf. bestimmen
   sz = size(F);  
   z = sz(1);  
   s = sz(2);
   % min. Frequenzen im Hochpass, ab 1/2 min_f (Abtasttheorem) 
   z_min = z * min_f / 2;
   s_min = s * min_f / 2;

   Fc = F;  % Kopie der Daten

   % durch alle Frequenzen, Zeilen und Spalten der FT 
   for( m = 1:z/2 )  
      for( n = 1:s/2 )
         % alle Frequenzen unterhalb min_f auf 0 setzen
         if( m <= z_min && n <= s_min )
            % symmetrisch fr alle Anteile wegen Abtasttheorem 
            Fc(m,n,1:3) = 0; % Frequenz zu m und n 
            Fc(z+1-m,n,1:3) = 0; % an z gespiegelte Frequenz 
            Fc(m,s+1-n,1:3) = 0; % an s gespiegelte Frequenz 
            Fc(z+1-m,s+1-n,1:3) = 0; % an z und s gespiegelt
         end
      end
   end
   
   Fi = ifft2( Fc );         % Rcktransformation
   Fr = uint8( abs( Fi ) );  % Absolutbetrag nach uint8 wandeln 
   % Ausgabe der Funktion nach Hochpass
   subplot( 1,2,2);  
   image( Fr );  
   axis image
end