function  huellkurve()
    SR = 4000;      % Sample-Rate
    dauer = 1/2;    % Dauer des Tons
    t = 0 : 1/SR : dauer;
    f   = 220;      % Grund-Frequenz 220 Hz
    A   = 1;        % 1 als Maximalwert
    
    % Array y mit Funktionswerten an den Sttzpunkten
    y = A * ( sin(2*pi*f*t)   + 1/3 * sin(2*pi*3*f*t) + ... 
        1/5 * sin(2*pi*5*f*t) + 1/7 * sin(2*pi*7*f*t) );
    
    % Hllkurven-Parameter:
    tattack  = 0.02;  %  Attack-Zeit in s
    hattack  = 1.0;   %  Attack-Hhe, relativ
    tsustain = 0.40;  %  Sustain-Zeit in s
    trelease = 0.05;  %  Release-Zeit in s 
    hrelease = 0.6;   %  Release-Hhe, relativ
    % einige typische Array-Punkte im Sample
    attLength  = tattack * SR;
    susLength  = tsustain * SR;
    relLength  = trelease * SR;
    endSustain = attLength + susLength;
    endRelease = endSustain + relLength;
    
    % Hllkurve-Effekt mit 0 vorbelegen
    effekt( 1:length(y) ) = 0; 
    % Effekt in der Attack-Phase
    for( s = 1:attLength )
       effekt(s) = s * hattack/attLength; 
    end
    % Effekt in der Sustain-Phase
    for( s = attLength:endSustain )
       effekt(s) = hattack - (s-attLength)*(hattack-hrelease)/susLength; 
    end
    % Effekt in der Release-Phase
    for( s = endSustain:endRelease )
       effekt(s) = hrelease - (s-endSustain)*hrelease/relLength; 
    end
       
    % Original y mit dem Effekt multiplizieren
    schwingung = y .* effekt;
    
    % Ausgabe der schwingung als 2D-plot
    subplot(2,1,1), 
    plot( t, schwingung );
    axis( [0 dauer -1 1] )
    
    % Fourier-Transformation
    c = fft( schwingung );
    
    % Betrag der Frequenz-Amplituden  
    A = abs( c );
    % Array der Frequenzen, normiert auf die Sample-Rate
    f = (0:length(c)-1).*SR/length(c);
    
    % 2D-plot der Frequenz-Amplituden ber den Frequenzen
    subplot(2,1,2)
    plot( f, A ) 
    % Frequenz-Bereich bis zur Hlfte der Sample-Rate
    axis( [0 SR/2 -1 1000] )
end