%  function [v, errNo, errMsg] = leseExcel( sK, z, datei )
%  liest aus der Excel-Datei mit dem Namen datei den Wert v 
%  in der Zelle zu Spaltenkenner sK (z.B. A) und Zeile z (z.B. Zahl 2)
%  
%  Die Rckgabeparameter dienen der Fehlerkontrolle (mit try-catch): 
%	errNo = 0, bei fehlerfreiem Lauf, errStr ist in diesem Fall leer
%	errNo = -1, bei Fehlers, errMsg = zugeh. Fehlermeldung
%
%  Beispielaufruf:  
%     [v, err, errStr] = leseExcel( 'C', 5, 'Module.xls' )
%
function [v, errNo, errMsg] = leseExcel( sK, z, datei )
   %Vorbelegung
   v      = [];    % noch kein Rckgabewert
   errNo  = -1;    % zur Sicherheit mit Fehler vorbelegen  
   errMsg = 'Unbekannter Fehler';   % 

   % Excel kontaktieren 
   ProgId = 'Excel.Application';
   try
       h = actxserver( ProgId );
   catch   % im Fehlerfall wird im Catch-Block weitergemacht:
       errNo  = -1;
       errMsg = ['Kein Kontakt zu COM-ProgId ', ProgId ];
       return;   % Funktion im Fehlerfall verlassen
   end
      
   % Workbooks-Interface holen
   hWBs = h.Workbooks;
   
   % Versuch, die Excel-Datei zu ffnen
   try
     map = hWBs.Open( datei );
   catch   % im Fehlerfall wird im Catch-Block weitergemacht: 
       errNo  = -1;
       errMsg = ['Kann Excel-Datei ', datei, ' nicht ffnen'];
       h.Quit    % COM-Server fr Excel beenden 
       h.delete  % COM-Objekt entfernen
       return;   % Funktion im Fehlerfall verlassen
   end
   
   % Interface zu Tabellen holen (ohne weiteren Check)
   Tabellen = map.Sheets; 
   % daraus erste Tabelle auswhlen (ohne weiteren Check)
   Tab1 = Tabellen.get( 'Item', 1 ); 
   
   % String fr Zellen-Bezeichnung zusammenbauen, z.B. 'C' + Zahl 5 
   zStr = sprintf( '%s%d', sK, z );   
   
   Zelle = Tab1.get( 'Range', zStr );
   % Wert auslesen
   v = Zelle.Value; 
   
   errNo = 1;    % alles OK, Zelle gefunden
   errMsg = [];  % Keine Fehlermeldung
   
   map.Close     % Excel-Datei schlieen 
   h.Quit        % COM-Server fr Excel beenden 
   h.delete      % COM-Objekt entfernen 