function newton( x0 )
   x_n = x0;
   n = 0;                % Start bei n = 0, mit x_n = x0 
   gefunden = 0;
    
   while( gefunden == 0 && n < 1000 )   % Iterationen
      n = n + 1;         % Zahl der Iterationen erhhen
      y_n = f0( x_n );   % =  y(xn)  Wert der Funktion bei x_n
      y_1 = f1( x_n );   % = y'(xn)  Wert der Ableitung

      x_next = x_n - y_n / y_1;  % Iterationsformel: n -> n+1
      y_next = f0( x_next );     % y-Wert zu x_next
      fprintf( 'x_n = %g, \t y_n = %g \n', x_next, y_next );
      
      if( abs( y_next ) < eps )  % Check, ob y_next nahe an 0
         fprintf( '\nNullstelle bei x = %g \n', x_next );
         fprintf( 'f(x) = %g, nach %d Iterationen \n', y_next, n );
         gefunden = 1;
      end
      x_n = x_next;  % neuer Wert fr x_n: n -> n+1
   end
   if( gefunden == 0 )  % Iteration war nicht erfolgreich
      fprintf( 'Keine Lsung nach %d Iterationen \n', n );  
   end
end

function y = f0( x )
   y = sin(x) - x/2;
end

function y = f1( x )
   y = cos(x) - 1/2;
end
   