function pendel_geregelt()
   % Parameter
   M = 2.0;
   m = 0.1;
   L = 1;
   g = 9.81;
   % Berechnung der System-Matrix
   a23 = m * g / M;
   a43 = (M+m) * g / (L * M);
   % Berechnung des Eingangsvektors
   b2  = 1/M;
   b4  = 1/(M*L);

   global A;  % global fr die DGL-Funktion
   A = [ 0  1  0  0;  ... 
         0  0 a23 0;  ... 
         0  0  0  1;  ... 
         0  0 a43 0 ]

   global b;  
   b = [ 0; b2; 0; b4 ]

   % Regelung: u = - k * x
   global k;
   k = [ -50   -50  260   80 ];

   % Eigenwerte der geregelten Matrix A
   Ak = A - b*k
   w = eig( Ak )
end   