%
%  Gaussverfahren: 2. Schritt 
%    Rckwrtseinsetzen 
%    aus Dreiecksmatrix A1:  A1*x = b1
%
function x = rueckwaerts( A1, b1 )
  sz = size( A1 );
  
  % von unten her aufrollen
  for( z =sz(1):-1:1 )
    diff = 0;
    for( s=z+1:sz(2) )
      diff = diff + A1(z,s)*x(s);
    end
    
    x(z) = ( b1(z) - diff ) / A1(z,z); 
  end
end
