function spektrumHamming_2()
   SR = 40000;  tm = 0.049; % 1/20;  % Sample-Rate und Zeitdauer
   % Zeit-Feld mit Sttzpunkten im Abstand 1/40000 s
   t = 0 : 1/SR : tm;   % Zeitintervall von 0 bis 1/20 s
   f = 440;      % Grundfrequenz 440 Hz
   A = 1;        % 1 als Maximalamplitude

   % Signal-Array: Grundton und drei Obertne
   y = A * ( sin(2*pi*f*t)   + 1/3 * sin(2*pi*3*f*t) + ... 
       1/5 * sin(2*pi*5*f*t) + 1/7 * sin(2*pi*7*f*t) );

   subplot(2,2,1)               % Ausgabe der Funktion als 2D-Plot
   plot( t, y );
   axis( [0 1/20 -1.1 1.1] )    % fester Ausgabebereich

   c = fft( y );                % Fourier-Transformation

   % Betrag der Frequenzamplituden und 
   %    Normierung der Amplituden durch den Faktor 2/(SR*tm)  
   A = abs( c ) * 2/(SR*tm);
   
   % Array der Frequenzen, normiert auf 40000 Hz
   f = linspace( 0, SR, length(c) );
   % Plot der Amplituden ber den Frequenzen
   subplot(2,2,2) 
   plot( f, A ) 
   axis( [0 4000 -0.0 1.0] )  % Frequenzbereich: 0 bis 4000 Hz

   % mit Hamming
   y1 = myHamming( length(y) );
   y2 = y .* y1;

   c2 = fft( y2 );                % Fourier-Transformation
   A2 = abs( c2 ) * 2/(SR*tm);
   
   subplot(2,2,3)               % Ausgabe der Funktion als 2D-Plot
   plot( t, y2 );
   axis( [0 1/20 -1.1 1.1] )    % fester Ausgabebereich

   subplot(2,2,4) 
   plot( f, A2 ) 
   axis( [0 4000 -0.0 1.0] )  % Frequenzbereich: 0 bis 4000 Hz


end

% L = N+1 = Anzahl der t-Werte, von 0 ab: 0 <= n <= N = L-1
function y = myHamming( L )
  N = L - 1;
  t = 0:N;   % L = N+1 t-Werte von 0 bis N  
  a = 25/46;
  b = 1 - a;
  y = a - b * cos( 2*pi*t / N ); 
end