function spektrumReal()
   SR = 40000;  tm = 1/20;  % Sample-Rate und Zeitdauer
   % Zeit-Feld mit Sttzpunkten im Abstand 1/40000 s
   t = 0 : 1/SR : tm;   % Zeitintervall von 0 bis 1/20 s
   f = 440;      % Grundfrequenz 440 Hz
   A = 1;        % 1 als Maximalamplitude

   % Signal-Array: Grundton und drei Obertne
   y = A * ( sin(2*pi*f*t)   + 1/3 * sin(2*pi*3*f*t) + ... 
       1/5 * sin(2*pi*5*f*t) + 1/7 * sin(2*pi*7*f*t) );

   figure   
   subplot(2,1,1)               % Ausgabe der Funktion als 2D-Plot
   plot( t, y );
   axis( [0 1/20 -1.1 1.1] )    % fester Ausgabebereich

   c = fft( y );                % Fourier-Transformation

   % Betrag der Frequenzamplituden und 
   %    Normierung der Amplituden durch den Faktor 2/(SR*tm)  
   A = -imag( c ) * 2/(SR*tm);
   
   % Array der Frequenzen, normiert auf 40000 Hz
   f = linspace( 0, SR, length(c) );
   % Plot der Amplituden ber den Frequenzen
   subplot(2,1,2) 
   plot( f, A ) 
   axis( [0 4000 -0.1 1.1] )  % Frequenzbereich: 0 bis 4000 Hz
end
