% 
%   Berechnung der Quadrat-Wurzel nach Heron 
%      
%      Newtonverfahren fr Nullstelle von f(x) = x^2 - a
%      Iteration xn+1 = ( xn + a/xn ) / 2 
% 
function [x,n] = sqrtHeron( a, epsi )

    n = 0;                  %Iterationsschritte 
    x = (a + 1) / 2;        % Startwert
    dist = abs( x^2 - a );  % Startdistanz     
    while( dist > epsi && n < 1000 )
       x = ( x + a/x ) / 2 
       dist = abs( x^2 - a );
       n = n + 1;
    end
end