function tiefpass( A, max_f )
   % Ursprungs-Datei plotten
   figure;  
   subplot(1,2,1);  image( A ); axis image

   F = fft2( double(A) ); % 2-dim. Fourier-Transformation

   % Zeilen- und Spalten-Zahl der Fourier-Tranf. bestimmen
   sz = size(F); 
   z = sz(1);  s = sz(2);
   % max. Frequenzen im Tiefpass, bis 1/2 max (Abtast-Theorem) 
   z_max = z * max_f / 2;
   s_max = s * max_f / 2;

   Fc = F;   % Kopie der Daten
   % durch alle Frequenzen, Zeilen und Spalten der FT 
   for( m = 1:z/2 )
      for( n = 1:s/2 )
         % alle Frequenzen oberhalb min_f auf 0 setzen
         if( m > z_max || n > s_max )
            Fc(m,n,1:3)     = 0; 
            Fc(z+1-m,n,1:3) = 0; 
            Fc(m,s+1-n,1:3) = 0; 
            Fc(z+1-m,s+1-n,1:3) = 0;  
         end
      end
   end

   Fi = ifft2( Fc );         % Rck-Transformation
   Fr = uint8( abs( Fi ) );  % Absolutbetrag nach uint8 wandeln 

   % Ausgabe der Funktion nach Tiefpass
   subplot(1,2,2);  
   image( Fr ); 
   axis image
end