%
%  Gaussverfahren: 1. Schritt 
%    Vorwrtselimination:  A*x = b
%    -> Dreiecksmatrix A1:  A1*x = b1
%
%  als Beispiel: gaussElimination.m 
%
function [A1,b1] = vorwaerts( A, b )

  sz = size( A );
  
  % ab der 2. Zeile Nullen erzeugen
  for( z=2:sz(1) )
    
    % 1. bis z-1. Spalte zu Null machen 
    for( s=1:z-1 )
       
      % Multiplikationsfaktor fr die ganze Zeile, 
       % um in z. Zeile und s. Spalte zu Null 
       v = - A(z,s) / A(s,s);
       
       % Zeile s von Zeile z abziehen, d.h. alle A(z,:) und b(z) 
       for( sa=1:sz(2) )
          A(z,sa) = A(z,sa) + v*A(s,sa);
       end  
       b(z) = b(z) + v*b(s);
    end  
  end

  % Rckgabewerte: 
  A1 = A; 
  b1 = b;
end
