function  zeichne_pendel( fun_dgl ) 
   t0 = 0;   % Zeitintervall 0 bis 20 s
   t1 = 10;
   tspan = [t0,t1];
   % Anfangszustand
   x0 = [ 1; 0.0; 0.1; 0.0 ];

   % DGL-Solver
   [t,x] = ode45( fun_dgl, tspan, x0 );

   % Grafische Ausgabe der Ergebnisse
   figure; 
   subplot( 2, 1, 1);  plot( t, x(:,1) );
   title( 'y : Wagen-Position' );
   axis( [t0 t1 -1 10] )  % Beschrnkung fr ungeregeltes Pendel
   subplot( 2, 1, 2);   plot( t, x(:,3) );
   title('phi : Winkel des Pendels' );
   axis( [t0 t1 -2 2] )  % Beschrnkung fr ungeregeltes Pendel

   figure;
   subplot( 2, 1, 1);   plot( t, x(:,2) );
   title( 'Wagen-Geschw.' );
   axis( [t0 t1 -10 100] )  % Beschrnkung fr ungeregeltes Pendel
   subplot( 2, 1, 2);   plot( t, x(:,4) );
   title('phi : Winkel-Geschw.' );
   axis( [t0 t1 -20 20] )  % Beschrnkung fr ungeregeltes Pendel
end