%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%  Funktion b06_init_data() Dummy-Funktion fr das Projekt Bildverarbeitung
%
%  Autor: Ulrich Stein, Dep. M+P, HAW Hamburg
%
%  Erzeugt:          28.04.2006
%  Letzte nderung:  28.04.2006
%
%--------------------------------------------------------------------
%
%  Initialisiert die Bild-Datenbasis.
%
%  Hinweis: Dieses Dummy-Projekt enthlt einige Debug-Ausgaben, 
%           die beim endgltigen Projekt natrlich abgeschaltet sind.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function  b06_data = b06_init_data( b06_data )

    % Variable zur Sicherheit lschen 
    clear b06_data; 
    
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    %
    % Bedeutung der Komponenten des structs b06_data:
    %
    %   oberste Ebene des structs b06_data mit den Komponenten:
    %     allg          Unter-struct mit allgemeine Daten zur Konfiguration
    %     orig          Array mit dem Original-Bild
    %     modif         Array mit dem modifizierten Bild
    %     preview       Array mit dem Vorschau-Bild
    %     rgb           Unter-struct mit Parametern zum rgb-Filter
    %     hochpass      Unter-struct mit Parametern zum Hochpass-Filter
    %     tiefpass      Unter-struct mit Parametern zum Tiefpass-Filter
    %     bw_col        Unter-struct mit Parametern zu Schwarz-Wei/Farbe 
    %     brightness    Unter-struct mit Parametern zur Helligkeit
    %     detail        Unter-struct mit Parametern zum Detail
    %
    b06_data = struct( 'allg', [],  ...
                       'orig', [], 'modif', [], 'preview', [], ...
                       'rgb', [], 'hochpass', [], 'tiefpass', [], ...,
                       'bw_col', [], 'brightness', [], 'detail', [] );
    
    %   Der Unter-struct allg enthlt folgende Komponenten: 
    %     version       Version des Bild-Projekts
    %     geladen       Flag, ob Bild geladen ist: 1 = ja, 0 = nein
    %     zeilen        Anzahl der Zeilen des Bildes
    %     spalten       Anzahl der Spalten des Bildes
    %     preview       ob aktuell das Preview angezeigt wird
    %     detail        Flag, ob Detail angezeigt werden soll, 1 = ja
    %     filename      Dateiname zum Speichern des Bildes
    %     handles       handles-struct des GUI fr Text-Ausgaben, etc.
    %
    b06_data.allg  = struct( 'version', 1.0, 'geladen', 0,  ...
                             'zeilen', 0, 'spalten', 0, ... 
                             'preview', 0, 'detail', 0, ...
                             'filename', '', 'handles', []  );
       
    %   Der Unter-struct rgb enthlt folgende Komponenten:  
    %     rbg           relative nderung der rgb_Werte
    %
    b06_data.rgb = struct( 'rgb', [1,1,1] );
                                                 
    %   Der Unter-struct hochpass enthlt folgende Komponenten:  
    %     frequenz      Abschneide-Frequenz fr niedrige Frequenzen
    %     intensitaet   Rest-Intensitten der niedrigen Frequenzen
    %
    b06_data.hochpass = struct( 'frequenz', 0, 'intensitaet', 0  );
                         
    %   Der Unter-struct tiefpass enthlt folgende Komponenten:  
    %     frequenz      Abschneide-Frequenz fr hohe Frequenzen
    %     intensitaet   Rest-Intensitten der hohen Frequenzen
    %
    b06_data.tiefpass = struct( 'frequenz', 0, 'intensitaet', 0  );
                         
    %   Der Unter-struct bw_col enthlt folgende Komponenten:  
    %     rbg           relativer rgb_Wert fr grau 
    %
    b06_data.bw_col = struct( 'rgb', [1,1,1]  );

    %   Der Unter-struct brightness enthlt folgende Komponenten:  
    %     helligkeit    relativer Wert fr die Helligkeit 
    %     invert        Flag, ob invertiert werden soll, 1 = ja
    %
    b06_data.brightness = struct( 'helligkeit', 1, 'invert', 0 );

    %   Der Unter-struct detail enthlt folgende Komponenten: 
    %     definiert     Flag, ob Detail definiert ist: 1 = ja, 0 = nein
    %     zeilen        relative Zeilen-Position des Details
    %     spalten       relative Spalten-Position des Details
    %
    b06_data.detail  = struct( 'definiert', 0,  ...
                             'zeilen', [0,1], 'spalten', [0,1]  );
                                             
return;
