%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%  Funktion s06_init_data() Dummy-Funktion fr das Projekt Sokoban
%
%  Autor: Ulrich Stein, Dep. M+P, HAW Hamburg
%
%  Erzeugt:          03.05.2006
%  Letzte nderung:  04.05.2006
%
%--------------------------------------------------------------------
%
%  Initialisiert die Spiel-Datenbasis.
%
%  Hinweis: Dieses Dummy-Projekt enthlt einige Debug-Ausgaben, 
%           die beim endgltigen Projekt natrlich abgeschaltet sind.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function s06_data = s06_init_data( s06_data )
        
    % Variable lschen 
    clear s06_data; 
    
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    %
    % Bedeutung der Komponenten des structs s06_data:
    %
    %   version     Version des Spiel-Projekts
    %   geladen     ob ein Spiel aktiv ist
    %   ende        ob ein Spiel beendet wurde
    %   pixel       Spielfiguren-Gre in Pixel, fest auf [16,20] 
    %   zeilen      wie viele Zeilen das Spielfeld hat
    %   spalten     wie viele Spalten das Spielfeld hat
    %   p           aktuelle Position der Spielfigur
    %   p_vor       vorherige Position der Spielfigur
    %   dir         Laufrichtung der Figur = Cursor-Taste
    %   figur       Unter-struct mit Optionen zur Figur
    %   anzziele    wie viele Ziele gibt es = ebenfalls Stein-Zahl
    %   ziel        struct-Array mit den Ziel-Positionen 
    %   feld        Belegung des Spielfeldes: 0 = Mauer, 
    %                   1 = freies Feld, 2 = Kiste
    %   feld_vor    Feld-Belegung vor dem letzten Zug fr Zurck
    %   imag        bmp-Bild-Array des Spielfeldes 
    %   handles     handles-struct des GUI fr Text-Ausgaben, etc.
    %
    s06_data = struct( 'version', 1.0, ...
                       'geladen', 0, 'ende', 0, 'pixel', [16,20], ...
                       'zeilen', 0, 'spalten', 0, ...
                       'p', [], 'p_vor', [], 'dir', 0, 'figur', [], ...
                       'anzziele', 0, 'ziel', [], ...
                       'feld', [], 'feld_vor', [], 'imag', [], ...
                       'handles', [] );
                
    %   Der Unter-struct figur enthlt folgende Komponenten: 
    %     nr      Nummer der Spiel-Figur (Auswahl aus mehreren)
    %     col     RGB-Farbe der Spiel-Figur
    %     back    1 = Zug zurck erlaubt, 0 = nicht erlaubt
    s06_data.figur = struct( 'nr', 1, 'col', [255,0,0], 'back', 1 );
    
     %   Der Unter-struct ziel enthlt folgende Komponenten: 
    %     x       x-Position des Ziels
    %     y       y-Position des Ziels
    s06_data.ziel = struct( 'x', [], 'y', [] );
    
  
    s06_data.geladen = 0;
    s06_data.zeilen  = 0;
    s06_data.spalten = 0;
    
    % feste Gre der Spielfiguren in Pixel
    s06_data.pixel = [16,20];
   
end
