%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%  Funktion s06_lese_spiel() Dummy-Funktion fr das Projekt Sokoban
%
%  Autor: Ulrich Stein, Dep. M+P, HAW Hamburg
%
%  Erzeugt:          03.05.2006
%  Letzte nderung:  04.05.2006
%
%--------------------------------------------------------------------
%
%  Spieldaten einlesen
%
%  Hinweis: Dieses Dummy-Projekt enthlt einige Debug-Ausgaben, 
%           die beim endgltigen Projekt natrlich abgeschaltet sind.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 
function s06_lese_spiel( FileName, PathName )

    global s06_data;  
    
    s06_data.geladen = 0;
        
    fid = fopen( FileName, 'r' );
    if( fid == -1 )
       beep;
       msg = ['Datei ', FileName, ' konnte nicht geffnet werden!'];
       errordlg( msg );
       return;
    end
    
    tline = fgetl(fid);
    if( s06_check_zeile1( tline ) == 1 ) 
      beep;
      errordlg( [FileName, ' ist keine gltige Spiel-Datei!'] );   
      fclose( fid );
      return;
    end
    
    while( 1 )
        tline = fgetl(fid);
        if ~ischar(tline)
            break;
        end
        
        if( s06_next_line(tline) == 1 )
          beep;
          errordlg( [FileName, ' ist keine gltige Spiel-Datei!'] );   
          fclose( fid );
          return;
        end  
    end
    
    fclose( fid );
    
    s06_data.geladen = 1;
    s06_data.p_vor = s06_data.p;
    
    % fr zurck merken
    s06_data.feld_vor = s06_data.feld;
    
    % Spielfeld zeichnen
    s06_draw;
    
return;

% in 1. Zeile muss 's06' stehen
function r = s06_check_zeile1( tline )
    % Check 1. Zeile
    if( strcmp( tline, 's06' ) == 1 )
        r = 0;
    else
        r = 1;
    end

return;

% nchste Zeile einlesen
function r = s06_next_line( tline )

    global s06_data;  
    
    r = 0;
    
    % 1. Zeichen der Zeile lesen
    c1 = tline(1);
    switch( c1 )
        % Kommentarzeile
        case '%'
            return;  
        case ' '
            return;
         
        % Erweitern um Versions-Nummer    
            
        % Zeilenzahl    
        case 'z'
            ln = sscanf( tline, '%c %d' );
            s06_data.zeilen  = ln(2);
        
        % Spaltenzahl
        case 's'
            ln = sscanf( tline, '%c %d' );
            s06_data.spalten  = ln(2);

            % Arrays initialisieren 
            if( s06_data.zeilen > 0 ) 
              s06_feld_init;
            end
            
        % Startposition    
        case 'p'
            ln = sscanf( tline, '%c %lg %lg' );
            s06_data.p(1) = ln(2);
            s06_data.p(2) = ln(3);
                    
            
        % Erweitern um Figur-Daten    
            
            
         % wie viele Ziele    
        case 'E'
            ln = sscanf( tline, '%c %d' );
            s06_data.anzziele = ln(2);
           
        % ein Ziel    
        case 'e'
            % Ziel: e nr z s
            ln = sscanf( tline, '%c %d %lg %lg' );
            nr = ln(2);
            s06_data.ziel(nr).x = ln(3);
            s06_data.ziel(nr).y = ln(4);
           
         % Zeilen mit Steinen 
         case 'n'
            if( s06_data.zeilen == 0 ) 
                beep;
                errordlg( 'Keine Zeilenzahl definiert!');
                r = 1;
                return;
            end
            if( s06_data.spalten == 0 ) 
                beep;
                errordlg( 'Keine Spaltenzahl definiert!');
                r = 1;
                return;
            end
             
            % Zeile einlesen, Steine stehen ab ln(3)
            ln = sscanf( tline, '%c %lg %s' );
            akt_zeile = ln(2);
               
            for( n= 1:s06_data.spalten ) 
              typ = str2double( char(ln(n+2)) );
              s06_data.feld( akt_zeile, n ) = typ;
            end        
          
        otherwise
            errordlg( ['Ungltiger Kenner ',c1] );
            r = 1;
            return;
    end

return;


   