%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%  Funktion s06_zeichne_figur() Dummy-Funktion fr das Projekt Sokoban
%
%  Autor: Ulrich Stein, Dep. M+P, HAW Hamburg
%
%  Erzeugt:          03.05.2006
%  Letzte nderung:  04.05.2006
%
%--------------------------------------------------------------------
%
%  Zeichnet die Figur, in Abhngigkeit von Laufrichtung 'dir'
%       dir = Cursor-Code:  < : 28, > : 29, ^ : 30, v : 31 
%
%   Der Unter-struct figur enthlt folgende Komponenten: 
%     nr      Nummer der Spiel-Figur (Auswahl aus mehreren)
%     col     RGB-Farbe der Spiel-Figur
%   s06_data.figur = struct( 'nr', 1, 'col', [255,0,0], 'back', 1 );
%
%  Hinweis: Dieses Dummy-Projekt enthlt einige Debug-Ausgaben, 
%           die beim endgltigen Projekt natrlich abgeschaltet sind.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 
function s06_zeichne_figur( m, n, dir, figur )

    global s06_data;  
    
    z_w = s06_data.pixel(1);
    s_w = s06_data.pixel(2);
          
    % Farben
    kr = 200;
    kg = 100;
    kb = 0;
    
    fr = 0;
    fg = 0;
    fb = 255;
    
    bw = 255;
    
    zr = [ bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw; ... 
           bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw; ... 
           bw bw bw bw bw bw bw bw fr fr fr fr bw bw bw bw bw bw bw bw; ... 
           bw bw bw bw bw bw bw bw kr kr kr bw bw bw bw bw bw bw bw bw; ... 
           bw bw bw bw bw bw bw bw kr kr kr bw bw bw bw bw bw bw bw bw; ... 
           bw bw bw bw bw bw bw bw bw kr bw bw bw bw bw bw bw bw bw bw; ... 
           bw bw bw bw bw bw bw fr fr fr fr fr bw bw bw bw bw bw bw bw; ... 
           bw bw bw bw bw bw fr bw fr fr fr bw fr bw bw bw bw bw bw bw; ... 
           bw bw bw bw bw bw bw bw fr fr fr bw bw bw bw bw bw bw bw bw; ... 
           bw bw bw bw bw bw bw bw fr fr fr bw bw bw bw bw bw bw bw bw; ... 
           bw bw bw bw bw bw bw bw fr fr fr bw bw bw bw bw bw bw bw bw; ... 
           bw bw bw bw bw bw bw fr bw bw bw fr bw bw bw bw bw bw bw bw; ... 
           bw bw bw bw bw bw bw fr bw bw bw fr bw bw bw bw bw bw bw bw; ... 
           bw bw bw bw bw bw fr fr bw bw bw fr fr bw bw bw bw bw bw bw; ... 
           bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw; ... 
           bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw ];
       
    zg = [ bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw; ... 
           bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw; ... 
           bw bw bw bw bw bw bw bw fg fg fg fg bw bw bw bw bw bw bw bw; ... 
           bw bw bw bw bw bw bw bw kg kg kg bw bw bw bw bw bw bw bw bw; ... 
           bw bw bw bw bw bw bw bw kg kg kg bw bw bw bw bw bw bw bw bw; ... 
           bw bw bw bw bw bw bw bw bw kg bw bw bw bw bw bw bw bw bw bw; ... 
           bw bw bw bw bw bw bw fg fg fg fg fg bw bw bw bw bw bw bw bw; ... 
           bw bw bw bw bw bw fg bw fg fg fg bw fg bw bw bw bw bw bw bw; ... 
           bw bw bw bw bw bw bw bw fg fg fg bw bw bw bw bw bw bw bw bw; ... 
           bw bw bw bw bw bw bw bw fg fg fg bw bw bw bw bw bw bw bw bw; ... 
           bw bw bw bw bw bw bw bw fg fg fg bw bw bw bw bw bw bw bw bw; ... 
           bw bw bw bw bw bw bw fg bw bw bw fg bw bw bw bw bw bw bw bw; ... 
           bw bw bw bw bw bw bw fg bw bw bw fg bw bw bw bw bw bw bw bw; ... 
           bw bw bw bw bw bw fg fg bw bw bw fg fg bw bw bw bw bw bw bw; ... 
           bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw; ... 
           bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw ];
       
    zb = [ bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw; ... 
           bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw; ... 
           bw bw bw bw bw bw bw bw fb fb fb fb bw bw bw bw bw bw bw bw; ... 
           bw bw bw bw bw bw bw bw kb kb kb bw bw bw bw bw bw bw bw bw; ... 
           bw bw bw bw bw bw bw bw kb kb kb bw bw bw bw bw bw bw bw bw; ... 
           bw bw bw bw bw bw bw bw bw kb bw bw bw bw bw bw bw bw bw bw; ... 
           bw bw bw bw bw bw bw fb fb fb fb fb bw bw bw bw bw bw bw bw; ... 
           bw bw bw bw bw bw fb bw fb fb fb bw fb bw bw bw bw bw bw bw; ... 
           bw bw bw bw bw bw bw bw fb fb fb bw bw bw bw bw bw bw bw bw; ... 
           bw bw bw bw bw bw bw bw fb fb fb bw bw bw bw bw bw bw bw bw; ... 
           bw bw bw bw bw bw bw bw fb fb fb bw bw bw bw bw bw bw bw bw; ... 
           bw bw bw bw bw bw bw fb bw bw bw fb bw bw bw bw bw bw bw bw; ... 
           bw bw bw bw bw bw bw fb bw bw bw fb bw bw bw bw bw bw bw bw; ... 
           bw bw bw bw bw bw fb fb bw bw bw fb fb bw bw bw bw bw bw bw; ... 
           bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw; ... 
           bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw bw ];
      
           
    for( r =1 : z_w )
      for( s =1 : s_w ) 
         s06_data.imag( (m-1)*z_w+ r ,(n-1)*s_w+ s, 1) = zr( r,s );
         s06_data.imag( (m-1)*z_w+ r ,(n-1)*s_w+ s, 2) = zg( r,s );
         s06_data.imag( (m-1)*z_w+ r ,(n-1)*s_w+ s, 3) = zb( r,s );
      end
    end    

return;    
