%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%  Funktion s06_ziehe() Dummy-Funktion fr das Projekt Sokoban
%
%  Autor: Ulrich Stein, Dep. M+P, HAW Hamburg
%
%  Erzeugt:          03.05.2006
%  Letzte nderung:  04.05.2006
%
%--------------------------------------------------------------------
%
%  Reaktion auf Cursor-Taste - ziehe Stein
%
%  Hinweis: Dieses Dummy-Projekt enthlt einige Debug-Ausgaben, 
%           die beim endgltigen Projekt natrlich abgeschaltet sind.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 
function  s06_ziehe( c ) 

    global s06_data;  
    
    if( s06_data.geladen == 0 )
      beep;
      msgbox( 'Kein Spiel geladen!' );
      return;        
    end

    % aktuelles Feld auslesen
    akt_x = s06_data.p(2);
    akt_y = s06_data.p(1);
    
    next_x = akt_x;
    next_y = akt_y;
    
    % aus Cursor-Taste nchstes Feld bestimmen
    % < : 28, > : 29, ^ : 30, v : 31 
    switch( c )
       case 28  % ein Feld nach links
           next_x = next_x - 1;  
       case 29  % ein Feld nach rechts 
           next_x = next_x + 1;  
       case 30  % ein Feld nach oben 
           next_y = next_y - 1;  
       case 31  % ein Feld nach unten 
           next_y = next_y + 1;  
            
       otherwise
          beep;
          errordlg( ['Unzulssige Eingabe: ',c] );
          return;    
    end
    
    
    % Check, ob Zug erlaubt ist:
    % (fr verschobene Kisten auch s06_data.feld ndern)
    %   - Feld in Laufrichtung frei: Ok, Position verschieben
    %   - Stein auf nchstem Feld: verboten
    %   - Kiste auf nchstem Feld: 
    %       Check ob bernchstes Feld frei, wenn Nein -> verboten
    %	    wenn ja: Kistenfeld mit 1 (frei) belegen, 
    %	              bernchstes Feld mit 2 (Kiste) belegen,
    %	              Figur Position auf nchstes Feld setzen

    fprintf( 'Debug: Logik erweitern \n');
    
    if( s06_data.feld(next_y,next_x) == 0 )
       beep;
       return; 
    end
    
    % Wenn alles OK ist, dann erst alte Position merken
    
    % Feld-Belegung fr zurck merken
    s06_data.feld_vor = s06_data.feld;
    % alte Position fr zurck merken
    s06_data.p_vor = s06_data.p;
    
    % Laufrichtung der Figur (Cursor-Taste)
    s06_data.dir = c;
    
    
    % und jetzt erst, nach dem Speichern der alten Daten, 
    % die nderungen vornehmen
   
    % neue aktuelle Daten merken
    s06_data.p = [next_y,next_x];
   
    % neu zeichnen
    s06_draw;
    
    
    % Check, ob alle Ziele erreicht sind
    fprintf( 'Debug: Check auf Ende einbauen \n' );
    
return;