%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%  Startfunktion t06() fr das Spiel TicTacToe
%
%  Autor: Ulrich Stein, Dep. M+P, HAW Hamburg
%
%  Erzeugt:          13.04.2006
%  Letzte nderung:  13.04.2006
%
%--------------------------------------------------------------------
%
%  TicTacToe ist das Hausarbeitsprojekt der Gruppe 2P-E im SS 2006.
%  Das Spiel luft in den beiden Spielfeld-Varianten 3x3 oder 4x4.
%  Spieler: Menschen oder Computer mit verschiedenen Strategien. 
%  Fr die Spielstein-Darstellung gibt es unterschiedliche Figuren.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function  t06()

    % globale Variable t06_data anlegen:  
    % muss in jeder function, die t06_data verwendet, 
    % ebenfalls so deklariert werden 
    global t06_data;  
    
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    %
    % Bedeutung der Komponenten des structs t06_data:
    %
    %   geladen     ob ein Spiel aktiv ist
    %   ende        ob ein Spiel beendet wurde
    %   zeilen      wie viele Zeilen das Spielfeld hat, 
    %                   erlaubt sind 3 oder 4
    %   name1       Name des 1. Spielers
    %   strategie1  Strategie des 1. Spielers:
    %                   0 : manuelle Eingabe der Spielzge
    %                   1 : Computer mit Strategie 1 
    %                   2 : Computer mit Strategie 2, nur fr 4x4 
    %   fig1        Nummer der Spielfigur fr Spieler 1 
    %   analog die Daten fr Spieler 2
    %   amzug       Merker, welcher Spieler am Zug ist, 1 oder 2
    %   pixel       Pixelzahl fr die Spielfigur, fest [16,16]
    %   feld        Belegung des Spielfeldes: 0 = freies Feld, 
    %                   1 = Stein von Spieler 1, 2 analog
    %   imag        bmp-Bild-Array des Spielfeldes mit den Steinen
    %   handles     handles-struct des GUI fr Text-Ausgaben, etc.
    %
    t06_data = struct( 'geladen', 0, 'ende', 0, ...
                       'zeilen', 3, ...
                       'name1', '', 'strategie1', 0, 'fig1', 1, ...
                       'name2', '', 'strategie2', 1, 'fig2', 2, ...
                       'amzug', 1,  'pixel', [], ...
                       'feld', [],  'imag', [], ...
                       'handles', [] );
                   
    % noch ist kein Spiel definiert:              
    t06_data.geladen = 0;                   
                       
    % TicTacToe-GUI starten    
    t06_gui;

return;
