%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%  Zeichnenfunktion t06_draw() fr das Spiel TicTacToe
%
%  Autor: Ulrich Stein, Dep. M+P, HAW Hamburg
%
%  Erzeugt:          13.04.2006
%  Letzte nderung:  13.04.2006
%
%--------------------------------------------------------------------
%
%  1. Spielfeld und Figuren zeichnen
%  2. Analysieren, ob ein Spieler gewonnen hat
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function  t06_draw()

    % Zugriff auf globale Variable t06_data
    global t06_data;  

    % Feld-Linien in Image eintragen
    t06_draw_lines();
    
    % alle Figuren in Image eintragen
    t06_draw_figures();
    
    % vor dem image zur Sicherheit nach uint8 wandeln
    t06_data.imag = uint8( t06_data.imag );

    % Und das Image anzeigen 
    image( t06_data.imag )
    axis image
    
    % Check, ob es einen Sieger gibt
    fprintf('Debug: Hier fehlt Check, ob es einen Sieger gibt \n' );
    
return;

    
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function  t06_draw_lines()

    % Zugriff auf globale Variable t06_data
    global t06_data;  

    % Anzahl der Pixel fr eine Spielfigur (zeilen,spalten)
    % sollte man am besten fr dieses Projekt fest lassen
    %   t06_data.pixel(1) = 16;
    %   t06_data.pixel(2) = 16;
    
    if( t06_data.zeilen == 3 )
        
      % 1. waagrechte Linie bei Pixel mit Zeile=16  
      t06_draw_horizontal( 16 );
      % 2. waagrechte Linie bei Pixel mit Zeile=32  
      t06_draw_horizontal( 32 );
      
      % 1. senkrechte Linie bei Pixel mit Zeile=16  
      % t06_draw_vertical( 16 );  etc.
      
    else
      fprintf('Debug: fr 4x4 fehlt es hier noch \n' );
    end
    
return;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function  t06_draw_horizontal( z )

    % Zugriff auf globale Variable t06_data
    global t06_data;  
    
    for( s=1:16*3 )
       t06_data.imag(z,s,1) = 0; % Rot  ganz aus
       t06_data.imag(z,s,2) = 0; % Grn ganz aus
       t06_data.imag(z,s,3) = 0; % Blau ganz aus
    end
            
return;
    
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function  t06_draw_figures()

    % Zugriff auf globale Variable t06_data
    global t06_data;  

    % Logisches Feld durchlaufen
    for( m = 1:t06_data.zeilen ) 
      for( n = 1:t06_data.zeilen ) 
          
         % 0 = leeres Feld, nichts zeichnen
         % 1 = mit Figur von Spieler 1,  2 = Figur Spieler 2 
         if( t06_data.feld(m,n) == 1 )
           t06_draw_figure( m, n, 1 );
         elseif( t06_data.feld(m,n) == 2 )
           t06_draw_figure( m, n, 2 );  
         end
             
      end
    end
    
return;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function  t06_draw_figure( m, n, spieler )

    % Zugriff auf globale Variable t06_data
    global t06_data;  
    
    % als Dummy nur mit unterschiedlichen Farben belegen
    for( z=1 : 16 )
      for( s =1 : 16 ) 
         if( spieler == 1 )
           t06_data.imag( (m-1)*16 +z ,(n-1)*16 +s, 3) = 0;
         else
           t06_data.imag( (m-1)*16 +z ,(n-1)*16 +s, 2) = 0;
         end
      end
    end
    
return;
