%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%  Funktion t06_dummy_data() mit Dummy-Daten fr das Spiel TicTacToe
%
%  Autor: Ulrich Stein, Dep. M+P, HAW Hamburg
%
%  Erzeugt:          13.04.2006
%  Letzte nderung:  13.04.2006
%
%--------------------------------------------------------------------
%
%  Diese Daten sollen ber den Dialog t06_option_gui kommen
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function  t06_dummy_data()

    % Zugriff auf globale Variable t06_data
    global t06_data;  

    %%%%% Diese Daten sollen ber einen Dialog kommen
    
    % wie viele Zeilen bzw. Spalten: 3 oder 4 sind erlaubt
    t06_data.zeilen    = 3;  % 3x3-Feld
    
    % Wer spielt gegen wen, mit welcher Strategie
    % Stategien: 0 = manuell, 1 = Computer-Strategie 1, etc.
    % welche Figur wird fr die Spieler verwendet
    
    % Name des 1. Spielers, als Mensch manuell (0)
    t06_data.name1      = 'Willy';  
    t06_data.strategie1 = 0;
    t06_data.fig1       = 1;
    
    % Name des 2. Spielers, als Computer mit Strategie 1
    t06_data.name2      = 'HAL';
    t06_data.strategie2 = 1;
    t06_data.fig2       = 2;
    
    % Spieler 1 ist am Zug
    t06_data.amzug = 1;
    
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    
    
    % Anzahl der Pixel fr eine Spielfigur (zeilen,spalten)
    % sollte man am besten fr dieses Projekt fest lassen
    t06_data.pixel(1) = 16;
    t06_data.pixel(2) = 16;
    
    % Logisches Feld initialisieren
    for( m = 1:t06_data.zeilen ) 
      for( n = 1:t06_data.zeilen ) 
         % 0 = leeres Feld, zu Beginn alle Felder leer
         % 1 = mit Figur von Spieler 1,  2 = Figur Spieler 2 
         t06_data.feld(m,n) = 0;
      end
    end
    
    % Image mit weiem Hintergrund initialisieren
    maxZeilen  = t06_data.zeilen * t06_data.pixel(1);
    maxSpalten = t06_data.zeilen * t06_data.pixel(2);
    
    for( m = 1:maxZeilen ) 
      for( n = 1:maxSpalten ) 
         t06_data.imag(m,n,1) = 255;  % Rot  voll auf
         t06_data.imag(m,n,2) = 255;  % Grn voll auf
         t06_data.imag(m,n,3) = 255;  % Blau voll auf
      end
    end
    
    % Spiel-Daten sind geladen
    t06_data.geladen = 1;
    t06_data.ende    = 0;

return;
