%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%  Funktion t06_play() fr das Spiel TicTacToe
%
%  Autor: Ulrich Stein, Dep. M+P, HAW Hamburg
%
%  Erzeugt:          13.04.2006
%  Letzte nderung:  13.04.2006
%
%--------------------------------------------------------------------
%
%  Steuerung des Spiel-Ablaufs
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function  t06_play()

    % Zugriff auf globale Variable t06_data
    global t06_data;  

    % Spielfeld zeichnen
    t06_draw;

    % Flag, ob noch Felder frei sind, 
    % bzw, ob jemand gewonnen hat
    t06_data.ende = 0;
    
    % in Schleife, bis zum Ende
    while( t06_data.ende == 0 )
        
        % Check, ob noch Felder frei sind
        ende = t06_felder_frei;
        if( ende )
            % Ende-Meldung, hier als Dummy-Meldung
            fprintf( 'Debug: Spiel zu Ende \n' );
            % Ende des Spiels
            return;
        end
        
        % Ablauf: Wer ist dran? 1 oder 2
        t06_ablauf;
                
        % Spielfeld wieder neu zeichnen
        % mit Check, ob jemand gewonnen hat
        t06_draw;
        
    end
return;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function ende = t06_felder_frei()

    % Zugriff auf globale Variable t06_data
    global t06_data;  
    
    ende = 0;
    
    % im logischen Feld nach 0 suchen
    for( m = 1:t06_data.zeilen ) 
      for( n = 1:t06_data.zeilen ) 
         % 0 = leeres Feld gefunden, 1 oder 2 = besetzt 
         if( t06_data.feld(m,n) == 0 )
           % alles OK, es gibt noch ein freies Feld  
           return;
         end
      end
    end
    
   % keine freien Felder mehr - Ende des Spiels
   fprintf( 'Debug: keine freien Felder mehr \n' );
   t06_data.ende = 1;
   ende = 1;

return;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Ablauf: Wer ist dran? 1 oder 2
function  t06_ablauf()
        
    % Zugriff auf globale Variable t06_data
    global t06_data;  
    
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  
    % Spieler 1 ist am Zug
    if( t06_data.amzug == 1 )
        
      % Wir schreiben erst mal, wer am Zug ist 
      txt = [t06_data.name1, ' ist am Zug'];
      set( t06_data.handles.textAmZug, 'String', txt );
        
      % ist 1 ein Mensch (0) oder Computer (1,2)
      if( t06_data.strategie1 == 0 )
        % zum Picken auffordern
        ok = 0;
        % Schleife, bis freies Feld gefunden
        while( ok == 0 )
          ok = t06_pick;
        end
      else
        % eingestellte Stategie abrufen, analog unten
        fprintf( 'Debug: hier ist noch nichts eingebaut \n');
      end

      % am Zug ist danach Spieler 2
      t06_data.amzug = 2;

    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  
    % Spieler 2 ist am Zug
    else
      % Wir schreiben erst mal, wer am Zug ist 
      txt = [t06_data.name2, ' ist am Zug'];
      set( t06_data.handles.textAmZug, 'String', txt );
        
      % ist 2 ein Mensch (0) oder Computer (1,2)
      if( t06_data.strategie2 == 0 )
        % zum Picken auffordern, analog oben
        fprintf( 'Debug: hier ist noch nichts eingebaut \n');
       
      % Computer ist am Zug  
      else
        % eingestellte Stategie abrufen
        % zurckgegeben wird zeile, spalte und ob Suche ok
        % entweder fr 3x3:
        ok = 0;
        if( t06_data.zeilen == 3 )
          [z,s,ok] = t06_strategie_3_3;  
        % oder fr 4x4, hier gibt es zwei Strategien:    
        else
          if( t06_data.strategie2 == 1 )
            [z,s,ok] = t06_strategieA_4_4;  
          else
            [z,s,ok] = t06_strategieB_4_4;  
          end
        end
        
        if( ok ) 
          t06_data.feld( z, s ) = t06_data.amzug;  
        else
          fprintf( 'Debug: Spiel zu Ende \n' );
          t06_data.ende = 1;
        end
        
      end

      % am Zug ist danach wieder Spieler 1
      t06_data.amzug = 1;
    end

return;
    
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function ok = t06_pick()
        
    % Zugriff auf globale Variable t06_data
    global t06_data; 
    
    % noch nichts ist ok 
    ok = 0;
    
    % mit der Maus picken
    [x,y] = ginput(1);
        
    % Anzahl der Pixel fr eine Spielfigur (zeilen,spalten)
    % sollte man am besten fr dieses Projekt fest lassen
    %   t06_data.pixel(1) = 16;
    %   t06_data.pixel(2) = 16;
    %
    % d.h. der gepickte Punkt liegt 
    % zwischen 0 und der maximalen Pixelzahl,
    % entweder 3 * 16 oder 4 * 16
    
    % ganzzahlig gerundeter Wert aus x und y
    spalte = int32(x/16 + 0.5); 
    zeile  = int32(y/16 + 0.5);
    
    fprintf('Debug: Der Spieler hat Feld %d,%d gewhlt \n', zeile,spalte );
    
    % Check, ob gepicktes Feld noch frei ist 
    if( t06_data.feld( zeile, spalte ) == 0 )  
      % Feld war frei und wird mit dem Spieler belegt, der am Zug ist:
      t06_data.feld( zeile, spalte ) = t06_data.amzug;
      ok = 1;
    else
      fprintf( 'Debug: Das Feld %d,%d ist bereits belegt \n', zeile, spalte );  
      ok = 0;  
    end
    
return;
      