%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%  Funktion t06_strategie_3_3() fr das Spiel TicTacToe
%
%  Autor: Ulrich Stein, Dep. M+P, HAW Hamburg
%
%  Erzeugt:          13.04.2006
%  Letzte nderung:  13.04.2006
%
%--------------------------------------------------------------------
%
%  Strategie fr 3x3-Spielfeld
%  Zurckgegeben werden Zeile z und Spalte s 
%  der automatisch bestimmten Zelle [z,s] und
%  ob die Strategie berhaupt etwas liefern konnte: ok = 1
%  Bei ok = 0 hat die Strategie versagt.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [z,s,ok] = t06_strategie_3_3()

  % Zugriff auf globale Variable t06_data
  global t06_data;  

  % Dumme Strategie: Suche 1. leeres Feld
  ok = 0;
  z  = 0;
  s  = 0;
  
  fprintf('Debug: jetzt ist der Computer dran \n' );
  
  % Logisches Feld durchsuchen
  [z,s,ok] = t06_suche_freies_feld;

return;

    
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function  [z,s,ok] = t06_suche_freies_feld()

  % Zugriff auf globale Variable t06_data
  global t06_data;  

  % Dumme Strategie: Suche 1. leeres Feld
  ok = 0;
  z  = 0;
  s  = 0;
  
  % Logisches Feld initialisieren
  for( m = 1:t06_data.zeilen ) 
    for( n = 1:t06_data.zeilen ) 
       % 0 = leeres Feld, zu Beginn alle Felder leer
       % 1 = mit Figur von Spieler 1,  2 = Figur Spieler 2 
       if( t06_data.feld(m,n) == 0 )
          
         % wir haben ein leeres Feld gefunden und
         % merken und Zeile und Spalte fr Rckgabe
         ok = 1;  
         z = m;
         s = n;
         
         fprintf('Debug: Der Computer hat Feld %d,%d gewhlt \n', z,s );
         
         % und beenden dann die weitere Suche
         return;
       end
    end
  end

return;

